/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.crypto;

import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosMac;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KerberosCipher {
    public static final int DES_CBC_CRC = 1;
    public static final int DES_CBC_MD5 = 3;
    public static int CONFOUNDER_LEN = 8;
    public static int MD5_CKSUM_LEN = 16;
    public static int CRC_CKSUM_LEN = 4;
    private int beginData;
    private int cksumLength;
    private Cipher desCipher;
    private KerberosMac mac;
    private int encType;
    private byte[] keyBytes;
    private SecureRandom rand;

    public KerberosCipher(KeyMaterial keyMaterial, SecureRandom secureRandom, String string) {
        this("DES/CBC/Zeroes", keyMaterial.getKeyType(), string);
        this.keyBytes = keyMaterial.getKeyBytes();
        this.rand = secureRandom;
    }

    private KerberosCipher(String string, int n, String string2) {
        try {
            this.desCipher = string2 == null ? Cipher.getInstance(string) : Cipher.getInstance(string, string2);
            this.encType = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        switch (this.encType) {
            case 1: {
                this.cksumLength = CRC_CKSUM_LEN;
                this.mac = KerberosMac.getInstance(1);
                break;
            }
            case 3: {
                this.cksumLength = MD5_CKSUM_LEN;
                this.mac = KerberosMac.getInstance(7);
                break;
            }
        }
        this.beginData = CONFOUNDER_LEN + this.cksumLength;
    }

    protected static void debug(String string, byte[] byArray) {
        System.out.print(string);
        int n = 0;
        while (n < byArray.length) {
            System.out.print(String.valueOf(Integer.toHexString(byArray[n] & 0xFF)) + " ");
            ++n;
        }
        System.out.println(" ");
    }

    public byte[] decrypt(EncryptedData encryptedData) throws CryptoException {
        if (encryptedData.getEncryptionType() != this.encType) {
            throw new CryptoException("Encryption type mismatch");
        }
        try {
            byte[] byArray = this.desCipher.doFinal(encryptedData.getCipherText());
            byte[] byArray2 = new byte[this.cksumLength];
            System.arraycopy(byArray, CONFOUNDER_LEN, byArray2, 0, this.cksumLength);
            int n = CONFOUNDER_LEN;
            while (n < this.beginData) {
                byArray[n] = 0;
                ++n;
            }
            byte[] byArray3 = new byte[byArray.length - this.beginData];
            System.arraycopy(byArray, this.beginData, byArray3, 0, byArray3.length);
            this.mac.update(byArray);
            byte[] byArray4 = this.mac.doFinal();
            if (!Arrays.equals(byArray2, byArray4)) {
                throw new CryptoException("Integrity check failure");
            }
            return byArray3;
        }
        catch (Exception exception) {
            throw new CryptoException(exception.toString());
        }
    }

    public EncryptedData encrypt(byte[] byArray) throws CryptoException {
        byte[] byArray2 = new byte[CONFOUNDER_LEN];
        this.rand.nextBytes(byArray2);
        int n = this.beginData + byArray.length;
        int n2 = 8 - n % 8;
        byte[] byArray3 = new byte[n + (n2 == 8 ? 0 : n2)];
        System.arraycopy(byArray2, 0, byArray3, 0, CONFOUNDER_LEN);
        System.arraycopy(byArray, 0, byArray3, this.beginData, byArray.length);
        this.mac.update(byArray3);
        byte[] byArray4 = this.mac.doFinal();
        System.arraycopy(byArray4, 0, byArray3, CONFOUNDER_LEN, this.cksumLength);
        try {
            byte[] byArray5 = this.desCipher.doFinal(byArray3);
            return new EncryptedData(this.encType, byArray5);
        }
        catch (Exception exception) {
            throw new CryptoException(exception.toString());
        }
    }

    private void init(int n, SecretKey secretKey) throws CryptoException {
        byte[] byArray = new byte[8];
        IvParameterSpec ivParameterSpec = this.encType == 1 ? new IvParameterSpec(secretKey.getEncoded()) : new IvParameterSpec(byArray);
        try {
            this.desCipher.init(n, (Key)secretKey, ivParameterSpec);
        }
        catch (Exception exception) {
            throw new CryptoException(exception.getMessage());
        }
    }

    public void initDecrypt() throws CryptoException {
        this.init(2, new SecretKeySpec(this.keyBytes, "DES"));
    }

    public void initEncrypt() throws CryptoException {
        this.init(1, new SecretKeySpec(this.keyBytes, "DES"));
    }
}

