/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.crypto;

import com.dstc.security.kerberos.crypto.KeyMaterial;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KerberosKey
implements KeyMaterial {
    private int type;
    private byte[] keyBytes = null;

    public KerberosKey(int n, String string) {
        this.type = n;
        this.keyBytes = KerberosKey.desStringToKey(string);
    }

    public KerberosKey(int n, byte[] byArray) {
        this.type = n;
        this.keyBytes = byArray;
    }

    protected static void debug(String string, byte[] byArray) {
        System.out.print(string);
        int n = 0;
        while (n < byArray.length) {
            System.out.print(String.valueOf(Integer.toHexString(byArray[n] & 0xFF)) + " ");
            ++n;
        }
        System.out.println(" ");
    }

    private static byte[] desStringToKey(String string) {
        byte[] byArray = new byte[8];
        byte[] byArray2 = string.getBytes();
        try {
            int n = 0;
            while (n < byArray2.length) {
                byte by = byArray2[n];
                if (n % 16 < 8) {
                    int n2 = n % 8;
                    byArray[n2] = (byte)(byArray[n2] ^ by << 1);
                } else {
                    by = (byte)(by << 4 & 0xF0 | by >> 4 & 0xF);
                    by = (byte)(by << 2 & 0xCC | by >> 2 & 0x33);
                    by = (byte)(by << 1 & 0xAA | by >> 1 & 0x55);
                    int n3 = 7 - n % 8;
                    byArray[n3] = (byte)(byArray[n3] ^ by);
                }
                ++n;
            }
            KerberosKey.forceOddParity(byArray);
            Mac mac = Mac.getInstance("DES-MAC");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "DES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
            mac.init(secretKeySpec, ivParameterSpec);
            byArray = mac.doFinal(string.getBytes());
            mac.reset();
            KerberosKey.forceOddParity(byArray);
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static final void forceOddParity(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            int n3 = 7;
            while (n3 >= 0) {
                n2 += byArray[n] >>> n3 & 1;
                --n3;
            }
            if (n2 % 2 == 0) {
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] ^ 1);
            }
            ++n;
        }
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public int getKeyType() {
        return this.type;
    }

    public void setKeyBytes(byte[] byArray) {
        this.keyBytes = byArray;
    }
}

