/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.kerberos.ApplicationRequest;
import com.dstc.security.kerberos.ApplicationResponse;
import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.KerberosCredential;
import com.dstc.security.kerberos.KerberosError;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.KerberosTicket;
import com.dstc.security.kerberos.creds.KeyTab;
import com.dstc.security.kerberos.creds.KeyTabEntry;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KerberosKey;
import com.dstc.security.kerberos.gssapi.ChannelBinding;
import com.dstc.security.kerberos.gssapi.GSSCredential;
import com.dstc.security.kerberos.gssapi.GSSException;
import com.dstc.security.kerberos.gssapi.GSSManager;
import com.dstc.security.kerberos.gssapi.GSSName;
import com.dstc.security.kerberos.gssapi.InitialToken;
import com.dstc.security.kerberos.gssapi.MessageProp;
import com.dstc.security.kerberos.gssapi.Oid;
import com.dstc.security.kerberos.gssapi.PerMessageToken;
import com.dstc.security.kerberos.gssapi.Token;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class GSSContext {
    public static final int INDEFINITE = Integer.MAX_VALUE;
    public static final int COMPLETE = 0;
    public static final int CONTINUE_NEEDED = 1;
    private static final int UNINITIALIZED = 0;
    private static final int CLIENT_AUTHENTICATED = 1;
    private static final int SERVER_AUTHENTICATED = 2;
    private static final int DELEG_FLAG = 1;
    private static final int MUTUAL_FLAG = 2;
    private static final int REPLAY_FLAG = 4;
    private static final int SEQUENCE_FLAG = 8;
    private static final int CONF_FLAG = 16;
    private static final int INTEG_FLAG = 32;
    private static final int ANON_FLAG = 64;
    private static final int PROT_READY_FLAG = 128;
    private static final int TRANS_FLAG = 256;
    private static final byte[] DES_MAC_MD5 = new byte[2];
    private static final byte[] DES_CBC = new byte[2];
    private static final byte[] NONE = new byte[]{-1, -1};
    private static final byte[] MIC_FILLER = new byte[]{-1, -1, -1, -1};
    private static final byte[] WRAP_FILLER = new byte[]{-1, -1};
    private static final byte[] INITIATOR = new byte[4];
    private static final byte[] ACCEPTOR = new byte[]{-1, -1, -1, -1};
    private static final int BLOCKSIZE = 8;
    private static final int INITIATE = 0;
    private static final int ACCEPT = 1;
    private GSSName peer;
    private int role;
    private Oid mechOid;
    private GSSCredential myCred;
    private GSSCredential delegCred;
    private int startTime;
    private int lifetime;
    private int state;
    private int sendSeqNum;
    private int recSeqNum;
    private byte[] cksumBytes;
    private KerberosKey contextKey = null;
    private SecureRandom rand = new SecureRandom(new byte[8]);
    private Date ctime;
    private int cusec;
    private static final int KRB5_CKSUM_TYPE = 32771;
    private static final int FLAGS_BYTE = 20;
    private Kerberos kerberos = Kerberos.getDefault();
    private Credential serviceCred = null;
    private KerberosCipher krbCipher = null;

    public GSSContext(GSSCredential gSSCredential) throws GSSException {
        if (gSSCredential == null) {
            gSSCredential = new GSSCredential(2);
        } else if (gSSCredential.getUsage() == 1) {
            throw new GSSException(7);
        }
        this.role = 1;
        this.myCred = gSSCredential;
        this.lifetime = this.myCred.getRemainingLifetime();
        this.state = 0;
    }

    public GSSContext(GSSName gSSName, Oid oid, GSSCredential gSSCredential, int n) throws GSSException {
        if (oid == null) {
            oid = GSSManager.getDefaultMech();
        }
        if (gSSCredential == null) {
            gSSCredential = new GSSCredential(null, n, oid, 1);
        } else if (gSSCredential.getUsage() == 2) {
            throw new GSSException(7);
        }
        if (oid.equals(GSSManager.KRB5)) {
            this.mechOid = GSSManager.KRB5;
            this.cksumBytes = new byte[24];
            this.cksumBytes[0] = 16;
            this.peer = gSSName.getStringNameType() != GSSName.KRB5_NT_PRINCIPAL_NAME ? gSSName.canonicalize(GSSManager.KRB5) : gSSName;
        } else {
            throw new GSSException(1);
        }
        this.role = 0;
        this.myCred = gSSCredential;
        this.lifetime = this.myCred.getRemainingLifetime();
        this.state = 0;
    }

    public GSSContext(byte[] byArray) throws GSSException {
    }

    public int accept(InputStream inputStream, OutputStream outputStream) throws GSSException {
        try {
            byte[] byArray = Token.readToken(inputStream);
            byArray = this.accept(byArray, 0, byArray.length);
            new InitialToken(byArray).write(outputStream);
            if (this.isEstablished()) {
                return 0;
            }
            return 1;
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public byte[] accept(byte[] byArray, int n, int n2) throws GSSException {
        try {
            Object object;
            InitialToken initialToken;
            Object object2;
            KeyTab keyTab = KeyTab.getDefault();
            String string = this.myCred.getGSSName().toString();
            KeyTabEntry keyTabEntry = keyTab.getKeyTabEntry(string);
            if (keyTabEntry == null) {
                throw new GSSException(13);
            }
            byte[] byArray2 = keyTabEntry.getKeyBytes();
            try {
                object2 = new byte[n2];
                System.arraycopy(byArray, n, object2, 0, n2);
                initialToken = new InitialToken((byte[])object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new GSSException(9);
            }
            if (initialToken == null) {
                throw new GSSException(9);
            }
            object2 = (ApplicationRequest)initialToken.getKrbMessage();
            KerberosTicket kerberosTicket = ((ApplicationRequest)object2).getTicket();
            kerberosTicket.initDecrypt(keyTabEntry);
            kerberosTicket.decrypt();
            this.contextKey = kerberosTicket.getContextKey();
            ((ApplicationRequest)object2).initDecrypt(this.contextKey);
            ((ApplicationRequest)object2).decrypt();
            if (((ApplicationRequest)object2).getSubKeyBytes() != null) {
                this.contextKey.setKeyBytes(((ApplicationRequest)object2).getSubKeyBytes());
            }
            this.cksumBytes = ((ApplicationRequest)object2).getChecksumBytes();
            this.peer = new GSSName(((ApplicationRequest)object2).getEncodedClientName(), GSSName.NT_EXPORT_NAME);
            if (this.getCredDelegState()) {
                object = new byte[2];
                System.arraycopy(this.cksumBytes, 26, object, 0, 2);
                int n3 = this.bytesToInt((byte[])object, 2);
                byte[] byArray3 = new byte[n3];
                System.arraycopy(this.cksumBytes, 28, byArray3, 0, n3);
                KerberosCredential kerberosCredential = new KerberosCredential(byArray3);
                kerberosCredential.initDecrypt(this.contextKey);
                kerberosCredential.decrypt();
                Credential credential = (Credential)kerberosCredential.getCredentials().firstElement();
                this.delegCred = new GSSCredential(this.peer, 1, credential);
            }
            this.startTime = (int)(System.currentTimeMillis() / 1000L);
            this.state = 1;
            if (this.getMutualAuthState()) {
                this.sendSeqNum = (int)(Math.random() * 16384.0);
                this.recSeqNum = ((ApplicationRequest)object2).getSequenceNumber();
                object = new ApplicationResponse(this.contextKey, this.rand);
                ((ApplicationResponse)object).setClientTime(((ApplicationRequest)object2).getClientTime());
                ((ApplicationResponse)object).setCusec(((ApplicationRequest)object2).getCusec());
                ((ApplicationResponse)object).setSequenceNumber(this.sendSeqNum);
                ((ApplicationResponse)object).encrypt();
                return new InitialToken(Token.KRB_AP_REP, (KerberosMessage)object).encode();
            }
            return null;
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GSSException(13);
        }
    }

    private int bytesToInt(byte[] byArray, int n) {
        if (n > 4) {
            n = 4;
        }
        int n2 = 0;
        while (--n >= 0) {
            n2 <<= 8;
            n2 |= byArray[n] & 0xFF;
        }
        return n2;
    }

    private byte[] computeChecksum(SecretKey secretKey, byte[] byArray, byte[] byArray2) throws GSSException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
            cipher.init(1, secretKey, new IvParameterSpec(new byte[8]), this.rand);
            byte[] byArray3 = new byte[8];
            System.arraycopy(cipher.doFinal(messageDigest.digest()), 8, byArray3, 0, 8);
            return byArray3;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    private void decryptSeqNum(SecretKey secretKey, byte[] byArray, byte[] byArray2, MessageProp messageProp) throws GSSException {
        block10: {
            try {
                Cipher cipher = Cipher.getInstance("DES/CBC/Zeroes");
                cipher.init(2, secretKey, new IvParameterSpec(byArray), this.rand);
                byte[] byArray3 = cipher.doFinal(byArray2);
                byte[] byArray4 = new byte[4];
                System.arraycopy(byArray3, 4, byArray4, 0, 4);
                if (this.role == 0 && Arrays.equals(ACCEPTOR, byArray4) || this.role == 1 && Arrays.equals(INITIATOR, byArray4)) {
                    if (this.getSequenceDetState()) {
                        byte[] byArray5 = new byte[4];
                        System.arraycopy(byArray3, 0, byArray5, 0, 4);
                        int n = this.bytesToInt(byArray5, 4);
                        if (this.recSeqNum == n) {
                            ++this.recSeqNum;
                        } else if (this.recSeqNum < n) {
                            messageProp.setGapToken(true);
                        } else if (this.recSeqNum > n) {
                            messageProp.setUnSeqToken(true);
                        }
                    }
                    break block10;
                }
                throw new GSSException(6);
            }
            catch (GSSException gSSException) {
                throw gSSException;
            }
            catch (Exception exception) {
                throw new GSSException(13);
            }
        }
    }

    public void dispose() throws GSSException {
        this.myCred = null;
        this.delegCred = null;
        this.contextKey = null;
    }

    private byte[] encryptSeqNum(SecretKey secretKey, byte[] byArray) throws GSSException {
        try {
            byte[] byArray2 = this.intToBytes(this.sendSeqNum, 4);
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray2, 0, byArray3, 0, 4);
            if (this.role == 0) {
                System.arraycopy(INITIATOR, 0, byArray3, 4, 4);
            } else {
                System.arraycopy(ACCEPTOR, 0, byArray3, 4, 4);
            }
            Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
            cipher.init(1, secretKey, new IvParameterSpec(byArray), this.rand);
            byte[] byArray4 = cipher.doFinal(byArray3);
            ++this.sendSeqNum;
            return byArray4;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public byte[] export() throws GSSException {
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        if (this.isTransferable()) {
            return null;
        }
        throw new GSSException(16);
    }

    public boolean getAnonymityState() {
        return (this.cksumBytes[20] & 0x40) == 64;
    }

    public boolean getConfState() {
        return (this.cksumBytes[20] & 0x10) == 16;
    }

    public boolean getCredDelegState() {
        return (this.cksumBytes[20] & 1) == 1;
    }

    public GSSCredential getDelegCred() throws GSSException {
        if (this.isEstablished() && this.getCredDelegState()) {
            return this.delegCred;
        }
        throw new GSSException(16);
    }

    public boolean getIntegState() {
        return (this.cksumBytes[20] & 0x20) == 32;
    }

    public int getLifetime() {
        if (this.isEstablished() || this.isProtReady() || this.lifetime == Integer.MAX_VALUE) {
            return this.lifetime;
        }
        int n = this.startTime + this.lifetime - (int)(System.currentTimeMillis() / 1000L);
        return n < 0 ? 0 : n;
    }

    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            byte[] byArray = Token.readToken(inputStream);
            byArray = this.getMIC(byArray, 0, byArray.length, messageProp);
            new PerMessageToken(byArray).write(outputStream);
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new GSSException(16);
        }
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(Token.MIC);
            byteArrayOutputStream.write(DES_MAC_MD5);
            byteArrayOutputStream.write(MIC_FILLER);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(new DESKeySpec(this.contextKey.getKeyBytes()));
            byte[] byArray3 = this.computeChecksum(secretKey, byteArrayOutputStream.toByteArray(), byArray2);
            byteArrayOutputStream.write(this.encryptSeqNum(secretKey, byArray3));
            byteArrayOutputStream.write(byArray3);
            messageProp.setQOP(0);
            return new PerMessageToken(Token.MIC, byteArrayOutputStream.toByteArray()).encode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GSSException(13);
        }
    }

    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    public boolean getMutualAuthState() {
        return (this.cksumBytes[20] & 2) == 2;
    }

    public boolean getReplayDetState() {
        return (this.cksumBytes[20] & 4) == 4;
    }

    public boolean getSequenceDetState() {
        return (this.cksumBytes[20] & 8) == 8;
    }

    public GSSName getSrcName() throws GSSException {
        if (this.isEstablished() || this.isProtReady()) {
            if (this.role == 0) {
                return this.myCred.getGSSName();
            }
            return this.peer;
        }
        throw new GSSException(16);
    }

    public GSSName getTargName() throws GSSException {
        if (this.isEstablished() || this.isProtReady()) {
            if (this.role == 1) {
                return this.myCred.getGSSName();
            }
            return this.peer;
        }
        throw new GSSException(16);
    }

    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        return 0;
    }

    public int init(InputStream inputStream, OutputStream outputStream) throws GSSException {
        try {
            byte[] byArray = Token.readToken(inputStream);
            byArray = this.init(byArray, 0, byArray.length);
            new InitialToken(byArray).write(outputStream);
            if (this.isEstablished()) {
                return 0;
            }
            return 1;
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public byte[] init(byte[] byArray, int n, int n2) throws GSSException {
        try {
            if (this.state == 0) {
                Object object;
                String string = this.peer.toString();
                String string2 = string.substring(0, string.indexOf(64));
                String string3 = this.kerberos.getKerberosContext().getRealm();
                this.serviceCred = this.kerberos.getServiceTicket(this.myCred.getTGTCredential(), string);
                this.contextKey = new KerberosKey(this.serviceCred.getKeyType(), this.serviceCred.getKeyBytes());
                this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 0x20);
                if (this.getSequenceDetState()) {
                    this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 2);
                }
                this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 0x80);
                this.cksumBytes[21] = (byte)(this.cksumBytes[21] | 1);
                this.startTime = (int)(System.currentTimeMillis() / 1000L);
                if (this.getCredDelegState()) {
                    object = string2.substring(string2.indexOf(47) + 1);
                    String string4 = InetAddress.getByName((String)object).getHostAddress();
                    Vector<Credential> vector = new Vector<Credential>();
                    try {
                        vector.addElement(this.kerberos.getDelegationCredential(string4));
                    }
                    catch (Exception exception) {
                        throw new GSSException(13);
                    }
                    KerberosCredential kerberosCredential = new KerberosCredential(this.contextKey, this.rand);
                    kerberosCredential.setCredentials(vector);
                    kerberosCredential.encrypt();
                    byte[] byArray2 = kerberosCredential.getEncoded();
                    byte[] byArray3 = this.intToBytes(1, 2);
                    byte[] byArray4 = this.intToBytes(byArray2.length, 2);
                    byte[] byArray5 = new byte[28 + byArray2.length];
                    System.arraycopy(this.cksumBytes, 0, byArray5, 0, 24);
                    System.arraycopy(byArray3, 0, byArray5, 24, 2);
                    System.arraycopy(byArray4, 0, byArray5, 26, 2);
                    System.arraycopy(byArray2, 0, byArray5, 28, byArray2.length);
                    this.cksumBytes = byArray5;
                }
                this.sendSeqNum = (int)(Math.random() * 16384.0);
                this.ctime = Calendar.getInstance().getTime();
                this.cusec = 0;
                object = new ApplicationRequest(this.serviceCred, this.rand);
                ((ApplicationRequest)object).setUseSessionKey(false);
                ((ApplicationRequest)object).setMutualAuthRequired(this.getMutualAuthState());
                ((ApplicationRequest)object).setRealm(string3);
                ((ApplicationRequest)object).setClientName(this.myCred.getGSSName().export());
                ((ApplicationRequest)object).setChecksumType(32771);
                ((ApplicationRequest)object).setChecksum(this.cksumBytes);
                ((ApplicationRequest)object).setCusec(this.cusec);
                ((ApplicationRequest)object).setClientTime(this.ctime);
                ((ApplicationRequest)object).setSequenceNumber(this.sendSeqNum);
                ((ApplicationRequest)object).encrypt();
                this.state = 1;
                return new InitialToken(Token.KRB_AP_REQ, (KerberosMessage)object).encode();
            }
            if (this.state == 1) {
                InitialToken initialToken;
                Object object;
                try {
                    object = new byte[n2];
                    System.arraycopy(byArray, n, object, 0, n2);
                    initialToken = new InitialToken((byte[])object);
                }
                catch (Exception exception) {
                    throw new GSSException(9);
                }
                if (initialToken == null) {
                    throw new GSSException(9);
                }
                try {
                    object = (KerberosError)initialToken.getKrbMessage();
                    throw new KerberosException(((KerberosError)object).getMessage());
                }
                catch (ClassCastException classCastException) {
                    object = (ApplicationResponse)initialToken.getKrbMessage();
                    ((ApplicationResponse)object).initDecrypt(this.serviceCred);
                    ((ApplicationResponse)object).decrypt();
                    this.recSeqNum = ((ApplicationResponse)object).getSequenceNumber();
                    if (this.cusec == ((ApplicationResponse)object).getCusec() && this.ctime.toString().equals(((ApplicationResponse)object).getClientTime().toString())) {
                        this.state = 2;
                        return null;
                    }
                    throw new GSSException(13);
                }
            }
            return null;
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GSSException(13);
        }
    }

    private byte[] intToBytes(int n, int n2) {
        if (n2 > 4) {
            n2 = 4;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)(n & 0xFF);
            n >>>= 8;
            ++n3;
        }
        return byArray;
    }

    public boolean isEstablished() {
        if (this.role == 0 && this.getMutualAuthState()) {
            return this.state == 2;
        }
        return this.state == 1;
    }

    public boolean isInitiator() throws GSSException {
        if (this.state != 0) {
            return this.role == 0;
        }
        throw new GSSException(16);
    }

    public boolean isProtReady() {
        return (this.cksumBytes[20] & 0x80) == 128;
    }

    public boolean isTransferable() throws GSSException {
        if (this.isEstablished()) {
            return (this.cksumBytes[21] & 1) == 1;
        }
        throw new GSSException(16);
    }

    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.state == 0 && this.role == 0) {
            if (bl) {
                throw new GSSException(16);
            }
        } else {
            throw new GSSException(16);
        }
    }

    public void requestConf(boolean bl) throws GSSException {
        if (this.state == 0 && this.role == 0) {
            if (bl) {
                this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 0x10);
            }
        } else {
            throw new GSSException(16);
        }
    }

    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.state == 0 && this.role == 0) {
            if (bl) {
                this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 1);
            }
        } else {
            throw new GSSException(16);
        }
    }

    public void requestInteg(boolean bl) throws GSSException {
        if (this.state != 0 || this.role != 0 || !bl) {
            throw new GSSException(16);
        }
        this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 0x20);
    }

    public void requestLifetime(int n) throws GSSException {
        if (this.state != 0 || this.role != 0) {
            throw new GSSException(16);
        }
        this.lifetime = n;
    }

    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.state == 0 && this.role == 0) {
            if (bl) {
                this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 2);
            }
        } else {
            throw new GSSException(16);
        }
    }

    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.state == 0 && this.role == 0) {
            if (bl) {
                this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 4);
            }
        } else {
            throw new GSSException(16);
        }
    }

    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.state == 0 && this.role == 0) {
            if (bl) {
                this.cksumBytes[20] = (byte)(this.cksumBytes[20] | 8);
            }
        } else {
            throw new GSSException(16);
        }
    }

    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        throw new GSSException(16);
    }

    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            byte[] byArray = Token.readToken(inputStream);
            byArray = this.unwrap(byArray, 0, byArray.length, messageProp);
            new PerMessageToken(byArray).write(outputStream);
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new GSSException(16);
        }
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        try {
            Object object;
            int n3;
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            byte[] byArray5;
            try {
                byArray5 = new byte[n2];
                System.arraycopy(byArray, n, byArray5, 0, n2);
                byArray4 = new PerMessageToken(byArray5).getInnerToken();
            }
            catch (Exception exception) {
                throw new GSSException(9);
            }
            if (byArray4 == null) {
                throw new GSSException(9);
            }
            byArray5 = new byte[8];
            System.arraycopy(byArray4, 8, byArray5, 0, 8);
            byte[] byArray6 = new byte[8];
            System.arraycopy(byArray4, 16, byArray6, 0, 8);
            byte[] byArray7 = new byte[byArray4.length - 24];
            System.arraycopy(byArray4, 24, byArray7, 0, byArray7.length);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(new DESKeySpec(this.contextKey.getKeyBytes()));
            byte[] byArray8 = new byte[2];
            System.arraycopy(byArray4, 4, byArray8, 0, 2);
            if (Arrays.equals(byArray8, NONE)) {
                byArray3 = byArray7;
                messageProp.setQOP(0);
                messageProp.setPrivacy(false);
            } else {
                byArray2 = new byte[8];
                n3 = 0;
                while (n3 < 8) {
                    byArray2[n3] = (byte)(this.contextKey.getKeyBytes()[n3] ^ 0xFFFFFFF0);
                    ++n3;
                }
                object = Cipher.getInstance("DES/CBC/Zeroes");
                ((Cipher)object).init(2, secretKeyFactory.generateSecret(new DESKeySpec(byArray2)), new IvParameterSpec(new byte[8]), this.rand);
                byArray3 = ((Cipher)object).doFinal(byArray7);
                messageProp.setQOP(0);
                messageProp.setPrivacy(true);
            }
            byArray2 = new byte[8];
            System.arraycopy(byArray4, 0, byArray2, 0, 8);
            if (!Arrays.equals(byArray6, this.computeChecksum(secretKey, byArray2, byArray3))) {
                throw new GSSException(6);
            }
            this.decryptSeqNum(secretKey, byArray6, byArray5, messageProp);
            n3 = byArray3.length;
            object = new byte[n3 - byArray3[n3 - 1] - 8];
            System.arraycopy(byArray3, 8, object, 0, ((Object)object).length);
            return object;
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GSSException(13);
        }
    }

    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        try {
            byte[] byArray = Token.readToken(inputStream);
            byte[] byArray2 = Token.readToken(inputStream2);
            this.verifyMIC(byArray, 0, byArray.length, byArray2, 0, byArray2.length, messageProp);
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new GSSException(16);
        }
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        try {
            byte[] byArray3;
            byte[] byArray4;
            try {
                byArray4 = new byte[n2];
                System.arraycopy(byArray, n, byArray4, 0, n2);
                byArray3 = new PerMessageToken(byArray4).getInnerToken();
            }
            catch (Exception exception) {
                throw new GSSException(9);
            }
            if (byArray3 == null) {
                throw new GSSException(9);
            }
            byArray4 = new byte[n4];
            System.arraycopy(byArray2, n3, byArray4, 0, n4);
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray3, 8, byArray5, 0, 8);
            byte[] byArray6 = new byte[8];
            System.arraycopy(byArray3, 16, byArray6, 0, 8);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(new DESKeySpec(this.contextKey.getKeyBytes()));
            byte[] byArray7 = new byte[8];
            System.arraycopy(byArray3, 0, byArray7, 0, 8);
            if (!Arrays.equals(byArray6, this.computeChecksum(secretKey, byArray7, byArray4))) {
                throw new GSSException(6);
            }
            this.decryptSeqNum(secretKey, byArray6, byArray5, messageProp);
            messageProp.setQOP(0);
            messageProp.setPrivacy(false);
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GSSException(13);
        }
    }

    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        try {
            byte[] byArray = Token.readToken(inputStream);
            byArray = this.wrap(byArray, 0, byArray.length, messageProp);
            new PerMessageToken(byArray).write(outputStream);
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (!this.isProtReady()) {
            throw new GSSException(16);
        }
        if (this.getLifetime() == 0) {
            throw new GSSException(12);
        }
        try {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(Token.WRAP);
            byteArrayOutputStream.write(DES_MAC_MD5);
            if (this.getConfState() && messageProp.getPrivacy()) {
                byteArrayOutputStream.write(DES_CBC);
            } else {
                byteArrayOutputStream.write(NONE);
            }
            byteArrayOutputStream.write(WRAP_FILLER);
            byte[] byArray3 = new byte[8];
            int n3 = byArray2.length % 8;
            int n4 = n3 != 0 ? 8 - n3 : 8;
            byte[] byArray4 = new byte[byArray2.length + 8 + n4];
            System.arraycopy(byArray3, 0, byArray4, 0, 8);
            System.arraycopy(byArray2, 0, byArray4, 8, byArray2.length);
            int n5 = 0;
            while (n5 < n4) {
                byArray4[byArray2.length + 8 + n5] = (byte)n4;
                ++n5;
            }
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = secretKeyFactory.generateSecret(new DESKeySpec(this.contextKey.getKeyBytes()));
            byte[] byArray5 = this.computeChecksum(secretKey, byteArrayOutputStream.toByteArray(), byArray4);
            byteArrayOutputStream.write(this.encryptSeqNum(secretKey, byArray5));
            byteArrayOutputStream.write(byArray5);
            if (this.getConfState() && messageProp.getPrivacy()) {
                byte[] byArray6 = new byte[8];
                int n6 = 0;
                while (n6 < 8) {
                    byArray6[n6] = (byte)(this.contextKey.getKeyBytes()[n6] ^ 0xFFFFFFF0);
                    ++n6;
                }
                Cipher cipher = Cipher.getInstance("DES/CBC/NoPadding");
                cipher.init(1, secretKeyFactory.generateSecret(new DESKeySpec(byArray6)), new IvParameterSpec(new byte[8]), this.rand);
                byte[] byArray7 = cipher.doFinal(byArray4);
                byteArrayOutputStream.write(byArray7);
                messageProp.setQOP(0);
                messageProp.setPrivacy(true);
            } else {
                byteArrayOutputStream.write(byArray4);
                messageProp.setQOP(0);
                messageProp.setPrivacy(false);
            }
            return new PerMessageToken(Token.WRAP, byteArrayOutputStream.toByteArray()).encode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GSSException(13);
        }
    }
}

