/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.gssapi.GSSException;
import com.dstc.security.kerberos.gssapi.GSSManager;
import com.dstc.security.kerberos.gssapi.GSSName;
import com.dstc.security.kerberos.gssapi.Oid;
import java.util.Date;

public class GSSCredential {
    public static final int INITIATE_AND_ACCEPT = 0;
    public static final int INITIATE_ONLY = 1;
    public static final int ACCEPT_ONLY = 2;
    public static final int INDEFINITE = Integer.MAX_VALUE;
    private GSSName name;
    private int usage;
    private Oid mechOid;
    private int initLifetime;
    private int acceptLifetime;
    private int startTime = (int)(System.currentTimeMillis() / 1000L);
    private Credential kerberosCredential;

    public GSSCredential(int n) throws GSSException {
        this((GSSName)null, Integer.MAX_VALUE, (Oid)null, n);
    }

    public GSSCredential(GSSName gSSName, int n) throws GSSException {
        this(gSSName, Integer.MAX_VALUE, (Oid)null, n);
    }

    GSSCredential(GSSName gSSName, int n, Credential credential) throws GSSException {
        this(gSSName, Integer.MAX_VALUE, GSSManager.KRB5, n);
        this.kerberosCredential = credential;
    }

    public GSSCredential(GSSName gSSName, int n, Oid oid, int n2) throws GSSException {
        if (n2 == 0) {
            this.initLifetime = n;
            this.acceptLifetime = n;
            this.usage = 0;
        } else if (n2 == 1) {
            this.initLifetime = n;
            this.usage = 1;
        } else if (n2 == 2) {
            this.acceptLifetime = n;
            this.usage = 2;
        } else {
            throw new GSSException(5);
        }
        if (oid == null) {
            oid = GSSManager.getDefaultMech();
        }
        if (oid.equals(GSSManager.KRB5)) {
            try {
                Kerberos kerberos = Kerberos.getDefault();
                this.name = gSSName == null ? new GSSName(kerberos.getKerberosContext().getUsername(), GSSName.NT_USER_NAME, GSSManager.KRB5) : (gSSName.getStringNameType() != GSSName.KRB5_NT_PRINCIPAL_NAME ? gSSName.canonicalize(GSSManager.KRB5) : gSSName);
                if (n2 == 1 || n2 == 0) {
                    this.kerberosCredential = kerberos.getTGTCredential();
                    if (this.kerberosCredential.getExpiryTime().before(new Date(this.startTime))) {
                        throw new GSSException(11);
                    }
                }
                this.mechOid = GSSManager.KRB5;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new GSSException(13);
            }
        } else {
            throw new GSSException(1);
        }
    }

    public GSSCredential(GSSName gSSName, int n, Oid[] oidArray, int n2) throws GSSException {
        this(gSSName, n, oidArray[0], n2);
        int n3 = 1;
        while (n3 < oidArray.length) {
            this.add(gSSName, n, n, oidArray[n3], n2);
            ++n3;
        }
    }

    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        throw new GSSException(16);
    }

    public void dispose() throws GSSException {
        this.kerberosCredential = null;
    }

    public boolean equals(Object object) {
        return object instanceof GSSCredential && this.name == ((GSSCredential)object).name;
    }

    public GSSName getGSSName() throws GSSException {
        return this.name;
    }

    public GSSName getGSSName(Oid oid) throws GSSException {
        if (oid.equals(this.mechOid)) {
            return this.name;
        }
        throw new GSSException(1);
    }

    public Oid[] getMechs() throws GSSException {
        Oid[] oidArray = new Oid[]{this.mechOid};
        return oidArray;
    }

    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (oid.equals(this.mechOid)) {
            if (this.acceptLifetime == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            int n = this.startTime + this.acceptLifetime - (int)(System.currentTimeMillis() / 1000L);
            return n < 0 ? 0 : n;
        }
        throw new GSSException(1);
    }

    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (oid.equals(this.mechOid)) {
            if (this.initLifetime == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            int n = this.startTime + this.initLifetime - (int)(System.currentTimeMillis() / 1000L);
            return n < 0 ? 0 : n;
        }
        throw new GSSException(1);
    }

    public int getRemainingLifetime() throws GSSException {
        if (this.usage == 1) {
            return this.getRemainingInitLifetime(this.mechOid);
        }
        if (this.usage == 2) {
            return this.getRemainingAcceptLifetime(this.mechOid);
        }
        return Math.min(this.getRemainingInitLifetime(this.mechOid), this.getRemainingAcceptLifetime(this.mechOid));
    }

    Credential getTGTCredential() {
        return this.kerberosCredential;
    }

    public int getUsage() throws GSSException {
        return this.usage;
    }

    public int getUsage(Oid oid) throws GSSException {
        if (oid.equals(this.mechOid)) {
            return this.usage;
        }
        throw new GSSException(1);
    }
}

