/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

public class GSSException
extends Exception {
    public static final int BAD_MECH = 1;
    public static final int BAD_NAME = 2;
    public static final int BAD_NAMETYPE = 3;
    public static final int BAD_BINDINGS = 4;
    public static final int BAD_STATUS = 5;
    public static final int BAD_MIC = 6;
    public static final int NO_CRED = 7;
    public static final int NO_CONTEXT = 8;
    public static final int DEFECTIVE_TOKEN = 9;
    public static final int DEFECTIVE_CREDENTIAL = 10;
    public static final int CREDENTIALS_EXPIRED = 11;
    public static final int CONTEXT_EXPIRED = 12;
    public static final int FAILURE = 13;
    public static final int BAD_QOP = 14;
    public static final int UNAUTHORIZED = 15;
    public static final int UNAVAILABLE = 16;
    public static final int DUPLICATE_ELEMENT = 17;
    public static final int NAME_NOT_MN = 18;
    private int majorCode;
    private int minorCode;
    private String minorString = "";

    public GSSException(int n) {
        this.majorCode = n;
    }

    public GSSException(int n, int n2, String string) {
        this.majorCode = n;
        this.minorCode = n2;
        this.minorString = string;
    }

    public int getMajor() {
        return this.majorCode;
    }

    public String getMajorString() {
        String string = "";
        switch (this.majorCode) {
            case 1: {
                string = "An unsupported mechanism was requested.\n";
                break;
            }
            case 2: {
                string = "An invalid name was supplied.\n";
                break;
            }
            case 3: {
                string = "A supplied name was of an unsupported type.\n";
                break;
            }
            case 4: {
                string = "Incorrect channel bindings were supplied.\n";
                break;
            }
            case 5: {
                string = "An invalid status code was supplied.\n";
                break;
            }
            case 6: {
                string = "A token had an invalid MIC.\n";
                break;
            }
            case 7: {
                string = "No credentials were supplied, or the credentials were unavailable or inaccessible.\n";
                break;
            }
            case 8: {
                string = "Invalid context has been supplied.\n";
                break;
            }
            case 9: {
                string = "A supplied token was invalid.\n";
                break;
            }
            case 10: {
                string = "A supplied credential was invalid.\n";
                break;
            }
            case 11: {
                string = "The referenced credentials have expired.\n";
                break;
            }
            case 12: {
                string = "The context has expired.\n";
                break;
            }
            case 13: {
                string = "Miscellaneous failure, unspecified at the GSS-API level.\n";
                break;
            }
            case 14: {
                string = "The quality-of-protection requested could not be provided.\n";
                break;
            }
            case 15: {
                string = "The operation is forbidden by local security policy.\n";
                break;
            }
            case 16: {
                string = "The operation or option is unavailable.\n";
                break;
            }
            case 17: {
                string = "The requested credential element already exists.\n";
                break;
            }
            case 18: {
                string = "The provided name was not a mechanism name.\n";
                break;
            }
        }
        return string;
    }

    public String getMessage() {
        return this.toString();
    }

    public int getMinor() {
        return this.minorCode;
    }

    public String getMinorString() {
        return this.minorString;
    }

    public void setMinor(int n, String string) {
        this.minorCode = n;
        this.minorString = string;
    }

    public String toString() {
        return String.valueOf(this.getMajorString()) + this.minorString;
    }
}

