/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.gssapi.GSSException;
import com.dstc.security.kerberos.gssapi.GSSManager;
import com.dstc.security.kerberos.gssapi.Oid;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import java.net.InetAddress;
import java.util.Vector;

public class GSSName {
    public static final Oid NT_HOSTBASED_SERVICE = new Oid("1.2.840.113554.1.2.1.4");
    public static final Oid NT_HOSTBASED_ALT = new Oid("1.3.6.1.5.6.2");
    public static final Oid NT_USER_NAME = new Oid("1.2.840.113554.1.2.1.1");
    public static final Oid NT_MACHINE_UID_NAME = new Oid("1.2.840.113554.1.2.1.2");
    public static final Oid NT_STRING_UID_NAME = new Oid("1.2.840.113554.1.2.1.3");
    public static final Oid NT_ANONYMOUS = new Oid("1.3.6.1.5.6.3");
    public static final Oid NT_EXPORT_NAME = new Oid("1.3.6.1.5.6.4");
    public static final Oid KRB5_NT_PRINCIPAL_NAME = new Oid("1.2.840.113554.1.2.2.1");
    private String nameStr;
    private Oid nameType;
    private Oid mechOid;
    private PrincipalName kerberosName;

    public GSSName(String string, Oid oid) throws GSSException {
        if (oid.equals(NT_HOSTBASED_SERVICE) || oid.equals(NT_HOSTBASED_ALT)) {
            this.makeHostBasedName(string);
        } else if (oid.equals(NT_USER_NAME)) {
            this.nameStr = string;
            this.nameType = NT_USER_NAME;
        } else if (oid.equals(KRB5_NT_PRINCIPAL_NAME)) {
            this.makeKrbName(string);
        } else {
            throw new GSSException(3);
        }
    }

    public GSSName(String string, Oid oid, Oid oid2) throws GSSException {
        this(string, oid);
        this.canonicalize(oid2);
    }

    public GSSName(byte[] byArray, Oid oid) throws GSSException {
        if (oid.equals(NT_HOSTBASED_SERVICE) || oid.equals(NT_HOSTBASED_ALT)) {
            this.makeHostBasedName(new String(byArray));
        } else if (oid.equals(NT_USER_NAME)) {
            this.nameStr = new String(byArray);
            this.nameType = NT_USER_NAME;
        } else if (oid.equals(KRB5_NT_PRINCIPAL_NAME)) {
            this.makeKrbName(new String(byArray));
        } else if (oid.equals(NT_EXPORT_NAME)) {
            try {
                this.kerberosName = new PrincipalName(byArray);
                Vector vector = this.kerberosName.getNameString();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(vector.elementAt(0));
                if (this.kerberosName.getNameType() == 3) {
                    stringBuffer.append("/");
                    stringBuffer.append(vector.elementAt(1));
                }
                this.makeKrbName(stringBuffer.toString());
            }
            catch (Exception exception) {
                throw new GSSException(2);
            }
        } else {
            throw new GSSException(3);
        }
    }

    public GSSName(byte[] byArray, Oid oid, Oid oid2) throws GSSException {
        this(byArray, oid);
        this.canonicalize(oid2);
    }

    public GSSName canonicalize(Oid oid) throws GSSException {
        try {
            if (oid.equals(GSSManager.KRB5)) {
                if (this.nameType.equals(NT_HOSTBASED_SERVICE)) {
                    this.makeKrbName(this.nameStr.replace('@', '/'));
                } else if (this.nameType.equals(NT_USER_NAME)) {
                    this.makeKrbName(this.nameStr);
                } else {
                    throw new GSSException(3);
                }
                return this;
            }
            throw new GSSException(1);
        }
        catch (GSSException gSSException) {
            throw gSSException;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            GSSName gSSName = new GSSName(this.nameStr, this.nameType);
            if (this.mechOid != null) {
                gSSName.canonicalize(this.mechOid);
            }
            return gSSName;
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException();
        }
    }

    public boolean equals(GSSName gSSName) throws GSSException {
        if (this.isAnonymous() || gSSName.isAnonymous()) {
            return false;
        }
        if (this.nameType.equals(gSSName.nameType)) {
            return this.nameStr.equals(gSSName.nameStr);
        }
        throw new GSSException(3);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GSSName) || this.isAnonymous() || ((GSSName)object).isAnonymous()) {
            return false;
        }
        return this.nameStr.equals(((GSSName)object).nameStr);
    }

    public byte[] export() throws GSSException {
        if (this.mechOid != null) {
            if (this.mechOid.equals(GSSManager.KRB5)) {
                return this.kerberosName.encode();
            }
            throw new GSSException(2);
        }
        throw new GSSException(18);
    }

    public Oid getStringNameType() throws GSSException {
        return this.nameType;
    }

    public boolean isAnonymous() {
        return this.nameType.equals(NT_ANONYMOUS);
    }

    private void makeHostBasedName(String string) throws GSSException {
        try {
            this.nameStr = string.indexOf(64) == -1 ? String.valueOf(string) + "@" + InetAddress.getLocalHost().getHostName() : string;
            this.nameType = NT_HOSTBASED_SERVICE;
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    private void makeKrbName(String string) throws GSSException {
        try {
            int n = string.indexOf(47);
            int n2 = string.indexOf(64);
            Vector<String> vector = new Vector<String>();
            if (n2 == -1) {
                if (n != -1) {
                    vector.addElement(string.substring(0, n));
                    vector.addElement(string.substring(n + 1));
                    this.kerberosName = new PrincipalName(3, vector);
                } else {
                    vector.addElement(string);
                    this.kerberosName = new PrincipalName(1, vector);
                }
                this.nameStr = String.valueOf(string) + "@" + Kerberos.getDefault().getKerberosContext().getRealm();
            } else {
                if (n != -1) {
                    vector.addElement(string.substring(0, n));
                    vector.addElement(string.substring(n + 1, n2));
                    this.kerberosName = new PrincipalName(3, vector);
                } else {
                    vector.addElement(string.substring(0, n2));
                    this.kerberosName = new PrincipalName(1, vector);
                }
                this.nameStr = string;
            }
            this.nameType = KRB5_NT_PRINCIPAL_NAME;
            this.mechOid = GSSManager.KRB5;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GSSException(13);
        }
    }

    public String toString() {
        return this.nameStr;
    }
}

