/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.kerberos.ApplicationRequest;
import com.dstc.security.kerberos.ApplicationResponse;
import com.dstc.security.kerberos.KerberosError;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.gssapi.Token;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

class InitialToken
extends Token {
    private KerberosMessage krbMessage = null;

    InitialToken(byte[] byArray) throws KerberosException, Asn1Exception {
        int[] nArray = new int[2];
        nArray[0] = Asn1.decodeLengthOctets(byArray, nArray);
        if (nArray[0] < 0) {
            return;
        }
        Oid oid = (Oid)Oid.decode(byArray, nArray);
        this.tokenId = new byte[2];
        System.arraycopy(byArray, nArray[1], this.tokenId, 0, 2);
        nArray[0] = nArray[1] + 2;
        Asn1 asn1 = Asn1.decode(byArray, nArray);
        this.krbMessage = Arrays.equals(this.tokenId, Token.KRB_AP_REQ) ? new ApplicationRequest(asn1.encode()) : (Arrays.equals(this.tokenId, Token.KRB_AP_REP) ? new ApplicationResponse(asn1.encode()) : (Arrays.equals(this.tokenId, Token.KRB_ERROR) ? new KerberosError(asn1.encode()) : null));
    }

    InitialToken(byte[] byArray, KerberosMessage kerberosMessage) {
        this.tokenId = byArray;
        this.krbMessage = kerberosMessage;
        this.setTagClass((byte)64);
        this.setTagNumber(0);
    }

    protected byte[] doContents() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(new Oid("1.2.840.113554.1.2.2").encode());
            byteArrayOutputStream.write(this.tokenId);
            byteArrayOutputStream.write(this.krbMessage.getEncoded());
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    KerberosMessage getKrbMessage() {
        return this.krbMessage;
    }
}

