/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.kerberos.gssapi.GSSException;
import com.dstc.security.kerberos.gssapi.Token;
import java.io.InputStream;

public class Oid {
    private String strOid;
    private com.dstc.security.asn1.Oid asn1Oid;

    public Oid(InputStream inputStream) throws GSSException {
        try {
            byte[] byArray = new byte[Token.readLength(inputStream)];
            inputStream.read(byArray);
            this.asn1Oid = (com.dstc.security.asn1.Oid)Asn1.decode(byArray);
            this.strOid = this.asn1Oid.getOid();
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public Oid(String string) {
        this.strOid = string;
        this.asn1Oid = new com.dstc.security.asn1.Oid(this.strOid);
    }

    public Oid(byte[] byArray) throws GSSException {
        try {
            this.asn1Oid = (com.dstc.security.asn1.Oid)Asn1.decode(byArray);
            this.strOid = this.asn1Oid.getOid();
        }
        catch (Exception exception) {
            throw new GSSException(13);
        }
    }

    public boolean containedIn(Oid[] oidArray) {
        int n = 0;
        while (n < oidArray.length) {
            if (this.equals(oidArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof Oid && ((Oid)object).strOid.compareTo(this.strOid) == 0;
    }

    public byte[] getDER() {
        return this.asn1Oid.encode();
    }

    public String toRFC2078String() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        stringBuffer.append(this.strOid.replace('.', ' '));
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.strOid;
    }
}

