/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.kerberos.gssapi.Token;
import java.io.ByteArrayOutputStream;

class PerMessageToken
extends Token {
    private byte[] innerToken;

    PerMessageToken(byte[] byArray) throws Asn1Exception {
        int[] nArray = new int[2];
        nArray[0] = Asn1.decodeLengthOctets(byArray, nArray);
        if (nArray[0] < 0) {
            return;
        }
        Oid oid = (Oid)Oid.decode(byArray, nArray);
        this.tokenId = new byte[2];
        System.arraycopy(byArray, nArray[1], this.tokenId, 0, 2);
        this.innerToken = new byte[byArray.length - nArray[1]];
        System.arraycopy(byArray, nArray[1], this.innerToken, 0, this.innerToken.length);
    }

    PerMessageToken(byte[] byArray, byte[] byArray2) {
        this.tokenId = byArray;
        this.innerToken = byArray2;
        this.setTagClass((byte)64);
        this.setTagNumber(0);
    }

    protected byte[] doContents() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(new Oid("1.2.840.113554.1.2.2").encode());
            byteArrayOutputStream.write(this.innerToken);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    byte[] getInnerToken() {
        return this.innerToken;
    }
}

