/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Constructed;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class Token
extends Constructed {
    public static final String kerberosMechType = "1.2.840.113554.1.2.2";
    public static final byte[] KRB_AP_REQ;
    public static final byte[] KRB_AP_REP;
    public static final byte[] KRB_ERROR;
    public static final byte[] MIC;
    public static final byte[] DEL_CTX;
    public static final byte[] WRAP;
    protected byte[] tokenId;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 1;
        KRB_AP_REQ = byArray;
        byte[] byArray2 = new byte[2];
        byArray2[0] = 2;
        KRB_AP_REP = byArray2;
        byte[] byArray3 = new byte[2];
        byArray3[0] = 3;
        KRB_ERROR = byArray3;
        MIC = new byte[]{1, 1};
        DEL_CTX = new byte[]{1, 2};
        WRAP = new byte[]{2, 1};
    }

    Token() {
    }

    protected static void debug(String string, byte[] byArray) {
        System.out.print(string);
        int n = 0;
        while (n < byArray.length) {
            System.out.print(String.valueOf(Integer.toHexString(byArray[n] & 0xFF)) + " ");
            ++n;
        }
        System.out.println(" ");
    }

    byte[] getTokenId() {
        return this.tokenId;
    }

    static int readLength(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[5];
        inputStream.mark(5);
        inputStream.read(byArray);
        inputStream.reset();
        byte by = byArray[1];
        int n = 1;
        if (by == -128) {
            return -1;
        }
        if ((by & 0x80) == 0) {
            return n + 1 + by;
        }
        int n2 = by & 0x7F;
        return n + 1 + n2 + Asn1.bytesToInt(byArray, n + 1, n2);
    }

    static byte[] readToken(InputStream inputStream) throws IOException {
        int n = Token.readLength(inputStream);
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        return byArray;
    }

    void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.encode());
    }
}

