/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.util.Vector;

public final class APRep
extends Explicit {
    public static final int TAG_KRB_AP_REP = 15;
    private static final int pvno = 5;
    private int msgType = 15;
    private EncryptedData encPart = null;

    public APRep(EncryptedData encryptedData) {
        super((byte)64, 15);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(5));
        sequence.addComponent(explicit);
        explicit = new Explicit(-128, 1);
        explicit.addComponent(new Integer(this.msgType));
        sequence.addComponent(explicit);
        this.encPart = encryptedData;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(encryptedData);
        sequence.addComponent(explicit);
        this.addComponent(sequence);
    }

    public APRep(byte[] byArray) throws Asn1Exception, BadMessageTypeException, BadVersionException {
        Explicit explicit;
        this.doDecode(byArray);
        if (this.getTagNumber() != 15) {
            throw new BadMessageTypeException("Wrong tag for an APRep");
        }
        Sequence sequence = (Sequence)this.getComponent();
        Vector vector = sequence.getComponents();
        int n = 0;
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag Number");
        }
        if (((Integer)explicit.getComponent()).getInt() != 5) {
            throw new BadVersionException("Not version 5");
        }
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        if (((Integer)explicit.getComponent()).getInt() != this.msgType) {
            throw new BadMessageTypeException("Wrong msgType for an APRep");
        }
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.encPart = new EncryptedData(explicit.getComponent().encode());
    }

    public EncryptedData getEncrypted() {
        return this.encPart;
    }
}

