/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.base.APOptions;
import com.dstc.security.kerberos.v5.creds.Ticket;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.util.Vector;

public final class APReq
extends Explicit {
    public static final int TAG_KRB_AP_REQ = 14;
    private static final int pvno = 5;
    private int msgType = 14;
    private APOptions apOptions;
    private Ticket ticket;
    private EncryptedData encAuthenticator;

    public APReq(APOptions aPOptions, Ticket ticket, EncryptedData encryptedData) {
        super((byte)64, 14);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(5));
        sequence.addComponent(explicit);
        explicit = new Explicit(-128, 1);
        explicit.addComponent(new Integer(this.msgType));
        sequence.addComponent(explicit);
        this.apOptions = aPOptions;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(aPOptions);
        sequence.addComponent(explicit);
        this.ticket = ticket;
        explicit = new Explicit(-128, 3);
        explicit.addComponent(ticket);
        sequence.addComponent(explicit);
        this.encAuthenticator = encryptedData;
        explicit = new Explicit(-128, 4);
        explicit.addComponent(encryptedData);
        sequence.addComponent(explicit);
        this.addComponent(sequence);
    }

    public APReq(byte[] byArray) throws Asn1Exception, BadVersionException, BadMessageTypeException {
        Explicit explicit;
        this.doDecode(byArray);
        if (this.getTagNumber() != 14) {
            throw new BadMessageTypeException("Wrong tag for an APReq");
        }
        Sequence sequence = (Sequence)this.getComponent();
        Vector vector = sequence.getComponents();
        int n = 0;
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag Number");
        }
        if (((Integer)explicit.getComponent()).getInt() != 5) {
            throw new BadVersionException("Not version 5");
        }
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        if (((Integer)explicit.getComponent()).getInt() != this.msgType) {
            throw new BadMessageTypeException("Wrong msgType for an APReq");
        }
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.apOptions = new APOptions(explicit.getComponent().encode());
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 3) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.ticket = new Ticket(explicit.getComponent().encode());
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 4) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.encAuthenticator = new EncryptedData(explicit.getComponent().encode());
    }

    public APOptions getAPOptions() {
        return this.apOptions;
    }

    public EncryptedData getEncrypted() {
        return this.encAuthenticator;
    }

    public Ticket getTicket() {
        return this.ticket;
    }
}

