/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;
import java.util.Vector;

public final class EncAPRepPart
extends Explicit {
    public static final int TAG_KRB_ENC_AP_REP_PART = 27;
    private KerberosTime ctime;
    private int cusec;
    private EncryptionKey key = null;
    private int seqNum;

    public EncAPRepPart(KerberosTime kerberosTime, int n, EncryptionKey encryptionKey, int n2) {
        super((byte)64, 27);
        Sequence sequence = new Sequence();
        this.ctime = kerberosTime;
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(kerberosTime);
        sequence.addComponent(explicit);
        this.cusec = n;
        explicit = new Explicit(-128, 1);
        explicit.addComponent(new Integer(n));
        sequence.addComponent(explicit);
        this.key = encryptionKey;
        if (encryptionKey != null) {
            explicit = new Explicit(-128, 2);
            explicit.addComponent(encryptionKey);
            sequence.addComponent(explicit);
        }
        this.seqNum = n2;
        if (n2 != -1) {
            explicit = new Explicit(-128, 3);
            explicit.addComponent(new Integer(n2));
            sequence.addComponent(explicit);
        }
        this.addComponent(sequence);
    }

    public EncAPRepPart(byte[] byArray) throws Asn1Exception, BadMessageTypeException {
        this.doDecode(byArray);
        if (this.getTagNumber() != 27) {
            throw new BadMessageTypeException("Wrong tag for an EncAPRepPart");
        }
        int n = 0;
        Sequence sequence = (Sequence)this.getComponent();
        Vector vector = sequence.getComponents();
        Explicit explicit = (Explicit)vector.elementAt(n++);
        this.ctime = new KerberosTime(explicit.getComponent().encode());
        explicit = (Explicit)vector.elementAt(n++);
        this.cusec = ((Integer)explicit.getComponent()).getInt();
        if (n >= vector.size()) {
            return;
        }
        explicit = (Explicit)vector.elementAt(n);
        if (explicit.getTagNumber() == 2) {
            this.key = new EncryptionKey(explicit.getComponent().encode());
            ++n;
        }
        if (n >= vector.size()) {
            return;
        }
        explicit = (Explicit)vector.elementAt(n);
        if (explicit.getTagNumber() == 3) {
            this.seqNum = ((Integer)explicit.getComponent()).getInt();
        }
    }

    public KerberosTime getClientTime() {
        return this.ctime;
    }

    public int getCusec() {
        return this.cusec;
    }

    public EncryptionKey getEncryptionKey() {
        return this.key;
    }

    public int getSequenceNumber() {
        return this.seqNum;
    }
}

