/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.base.HostAddresses;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.LastReq;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.base.TicketFlags;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;

public final class EncKDCRepPart
extends Sequence {
    private EncryptionKey key = null;
    private LastReq lastReq = null;
    private int nonce;
    private KerberosTime keyExp = null;
    private TicketFlags flags = null;
    private KerberosTime authTime = null;
    private KerberosTime startTime = null;
    private KerberosTime endTime = null;
    private KerberosTime renewTill = null;
    private Realm sRealm = null;
    private PrincipalName sName = null;
    private HostAddresses caddr = null;

    public EncKDCRepPart() {
    }

    public EncKDCRepPart(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        Explicit explicit = (Explicit)this.components.elementAt(n++);
        this.key = new EncryptionKey(explicit.getComponent().encode());
        explicit = (Explicit)this.components.elementAt(n++);
        this.lastReq = new LastReq(explicit.getComponent().encode());
        explicit = (Explicit)this.components.elementAt(n++);
        this.nonce = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)this.components.elementAt(n);
        if (explicit.getTagNumber() == 3) {
            this.keyExp = new KerberosTime(explicit.getComponent().encode());
        }
        int n2 = ++n;
        explicit = (Explicit)this.components.elementAt(n2);
        this.flags = new TicketFlags(explicit.getComponent().encode());
        int n3 = ++n;
        explicit = (Explicit)this.components.elementAt(n3);
        this.authTime = new KerberosTime(explicit.getComponent().encode());
        if ((explicit = (Explicit)this.components.elementAt(++n)).getTagNumber() == 6) {
            this.startTime = new KerberosTime(explicit.getComponent().encode());
        }
        int n4 = ++n;
        explicit = (Explicit)this.components.elementAt(n4);
        this.endTime = new KerberosTime(explicit.getComponent().encode());
        if ((explicit = (Explicit)this.components.elementAt(++n)).getTagNumber() == 8) {
            this.renewTill = new KerberosTime(explicit.getComponent().encode());
        }
        int n5 = ++n;
        explicit = (Explicit)this.components.elementAt(n5);
        this.sRealm = new Realm(explicit.getComponent().encode());
        int n6 = ++n;
        explicit = (Explicit)this.components.elementAt(n6);
        this.sName = new PrincipalName(explicit.getComponent().encode());
        if (++n < this.components.size()) {
            explicit = (Explicit)this.components.elementAt(n++);
            this.caddr = new HostAddresses(explicit.getComponent().encode());
        }
    }

    public KerberosTime getAuthTime() {
        return this.authTime;
    }

    public HostAddresses getClientAddresses() {
        return this.caddr;
    }

    public EncryptionKey getEncryptionKey() {
        return this.key;
    }

    public KerberosTime getEndTime() {
        return this.endTime;
    }

    public KerberosTime getKeyExpiryTime() {
        return this.keyExp;
    }

    public LastReq getLastReq() {
        return this.lastReq;
    }

    public int getNonce() {
        return this.nonce;
    }

    public KerberosTime getRenewTill() {
        return this.renewTill;
    }

    public PrincipalName getServerName() {
        return this.sName;
    }

    public Realm getServerRealm() {
        return this.sRealm;
    }

    public KerberosTime getStartTime() {
        return this.startTime;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }
}

