/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.KrbCredInfo;
import com.dstc.security.kerberos.v5.base.HostAddress;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import java.util.Enumeration;
import java.util.Vector;

public final class EncKrbCredPart
extends Explicit {
    public static final int TAG_KRB_ENC_KRB_CRED_PART = 29;
    private Vector credsInfo;
    private int nonce = 0;
    private KerberosTime timestamp;
    private int usec = 0;
    private HostAddress s_address;
    private HostAddress r_address;

    public EncKrbCredPart(Vector vector, int n, String string, String string2) {
        super((byte)64, 29);
        Sequence sequence = new Sequence();
        this.credsInfo = vector;
        CredInfoSeq credInfoSeq = new CredInfoSeq(vector);
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(credInfoSeq);
        sequence.addComponent(explicit);
        this.nonce = n;
        if (n != 0) {
            explicit = new Explicit(-128, 1);
            explicit.addComponent(new Integer(n));
            sequence.addComponent(explicit);
        }
        this.timestamp = new KerberosTime();
        explicit = new Explicit(-128, 2);
        explicit.addComponent(this.timestamp);
        sequence.addComponent(explicit);
        this.usec = 0;
        explicit = new Explicit(-128, 3);
        explicit.addComponent(new Integer(this.usec));
        sequence.addComponent(explicit);
        if (this.s_address != null) {
            this.s_address = new HostAddress(string);
            explicit = new Explicit(-128, 4);
            explicit.addComponent(this.s_address);
            sequence.addComponent(explicit);
        }
        if (this.r_address != null) {
            this.r_address = new HostAddress(string2);
            explicit = new Explicit(-128, 5);
            explicit.addComponent(this.r_address);
            sequence.addComponent(explicit);
        }
        this.addComponent(sequence);
    }

    public EncKrbCredPart(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        if (this.getTagNumber() != 29) {
            throw new Asn1Exception("Bad Tag Number");
        }
        Sequence sequence = (Sequence)this.getComponent();
        Enumeration enumeration = sequence.getComponents().elements();
        Explicit explicit = (Explicit)enumeration.nextElement();
        CredInfoSeq credInfoSeq = new CredInfoSeq(explicit.getComponent().encode());
        this.credsInfo = credInfoSeq.credsInfo;
        int n = 0;
        while (enumeration.hasMoreElements()) {
            explicit = (Explicit)enumeration.nextElement();
            int n2 = explicit.getTagNumber();
            if (n2 <= n) {
                throw new Asn1Exception("Sequence out of order");
            }
            n = n2;
            switch (n2) {
                case 1: {
                    this.nonce = ((Integer)explicit.getComponent()).getInt();
                    break;
                }
                case 2: {
                    this.timestamp = new KerberosTime(explicit.getComponent().encode());
                    break;
                }
                case 3: {
                    this.usec = ((Integer)explicit.getComponent()).getInt();
                    break;
                }
                case 4: {
                    this.s_address = new HostAddress(explicit.getComponent().encode());
                    break;
                }
                case 5: {
                    this.r_address = new HostAddress(explicit.getComponent().encode());
                    break;
                }
                default: {
                    throw new Asn1Exception("Invalid context tag number in sequence");
                }
            }
        }
    }

    public Vector getCredsInfo() {
        return this.credsInfo;
    }

    public int getNonce() {
        return this.nonce;
    }

    public HostAddress getReceiverAddress() {
        return this.r_address;
    }

    public HostAddress getSenderAddress() {
        return this.s_address;
    }

    public KerberosTime getTimestamp() {
        return this.timestamp;
    }

    public int getUsec() {
        return this.usec;
    }

    protected class CredInfoSeq
    extends Sequence {
        protected Vector credsInfo;

        protected CredInfoSeq(Vector vector) {
            this.credsInfo = vector;
            int n = 0;
            while (n < vector.size()) {
                KrbCredInfo krbCredInfo = (KrbCredInfo)vector.elementAt(n);
                this.addComponent(krbCredInfo);
                ++n;
            }
        }

        protected CredInfoSeq(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.credsInfo = new Vector(this.components.size());
            int n = 0;
            while (n < this.components.size()) {
                KrbCredInfo krbCredInfo = new KrbCredInfo(((Asn1)this.components.elementAt(n)).encode());
                this.credsInfo.addElement(krbCredInfo);
                ++n;
            }
        }
    }
}

