/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.creds.Ticket;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;

public final class KDCRep
extends Sequence {
    private int pvno = 5;
    private int msgType;
    private Realm cRealm;
    private PrincipalName cName;
    private Ticket ticket;
    private EncryptedData encPart;

    public KDCRep() {
    }

    public KDCRep(byte[] byArray) throws Asn1Exception, BadVersionException {
        this.doDecode(byArray);
        int n = 0;
        Explicit explicit = (Explicit)this.components.elementAt(n++);
        if (((Integer)explicit.getComponent()).getInt() != this.pvno) {
            throw new BadVersionException("Not version 5");
        }
        explicit = (Explicit)this.components.elementAt(n++);
        this.msgType = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)this.components.elementAt(n);
        if (explicit.getTagNumber() == 2) {
            // empty if block
        }
        int n2 = ++n;
        explicit = (Explicit)this.components.elementAt(n2);
        this.cRealm = new Realm(explicit.getComponent().encode());
        int n3 = ++n;
        explicit = (Explicit)this.components.elementAt(n3);
        this.cName = new PrincipalName(explicit.getComponent().encode());
        int n4 = ++n;
        explicit = (Explicit)this.components.elementAt(n4);
        this.ticket = new Ticket(explicit.getComponent().encode());
        int n5 = ++n;
        ++n;
        explicit = (Explicit)this.components.elementAt(n5);
        this.encPart = new EncryptedData(explicit.getComponent().encode());
    }

    public PrincipalName getClientName() {
        return this.cName;
    }

    public Realm getClientRealm() {
        return this.cRealm;
    }

    public EncryptedData getEncrypted() {
        return this.encPart;
    }

    public int getMsgType() {
        return this.msgType;
    }

    public Ticket getTicket() {
        return this.ticket;
    }
}

