/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.KDCReqBody;
import com.dstc.security.kerberos.v5.PaData;
import java.util.Enumeration;
import java.util.Vector;

public final class KDCReq
extends Sequence {
    private static final int pvno = 5;
    private int msgType;
    private PaDataSeq paDataSeq;
    private KDCReqBody reqBody;

    public KDCReq(int n, KDCReqBody kDCReqBody, Vector vector) {
        Explicit explicit = new Explicit(-128, 1);
        explicit.addComponent(new Integer(5));
        this.addComponent(explicit);
        this.msgType = n;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(new Integer(n));
        this.addComponent(explicit);
        if (vector != null) {
            this.paDataSeq = new PaDataSeq(vector);
            explicit = new Explicit(-128, 3);
            explicit.addComponent(this.paDataSeq);
            this.addComponent(explicit);
        }
        this.reqBody = kDCReqBody;
        explicit = new Explicit(-128, 4);
        explicit.addComponent(kDCReqBody);
        this.addComponent(explicit);
    }

    public KDCReq(byte[] byArray) throws Asn1Exception, BadVersionException {
        this.doDecode(byArray);
        Enumeration enumeration = this.getComponents().elements();
        Explicit explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 1) {
            throw new Asn1Exception("Bad tag number");
        }
        if (((Integer)explicit.getComponent()).getInt() != 5) {
            throw new BadVersionException("Bad version number");
        }
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 2) {
            throw new Asn1Exception("Bad tag number");
        }
        this.msgType = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() == 3) {
            this.paDataSeq = new PaDataSeq(explicit.getComponent().encode());
            explicit = (Explicit)enumeration.nextElement();
        }
        if (explicit.getTagNumber() != 4) {
            throw new Asn1Exception("Bad tag number");
        }
        this.reqBody = new KDCReqBody(explicit.getComponent().encode());
    }

    public int getMsgType() {
        return this.msgType;
    }

    public Vector getPadatas() {
        return this.paDataSeq.padatas;
    }

    protected class PaDataSeq
    extends Sequence {
        private Vector padatas = new Vector();

        protected PaDataSeq(Vector vector) {
            this.padatas = vector;
            int n = 0;
            while (n < vector.size()) {
                this.addComponent((Asn1)vector.elementAt(n));
                ++n;
            }
        }

        protected PaDataSeq(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            int n = 0;
            while (n < this.components.size()) {
                this.padatas.addElement(new PaData(((Asn1)this.components.elementAt(n)).encode()));
                ++n;
            }
        }
    }
}

