/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.TicketsSeq;
import com.dstc.security.kerberos.v5.base.HostAddresses;
import com.dstc.security.kerberos.v5.base.KDCOptions;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import com.dstc.security.kerberos.v5.crypto.EncryptionType;
import java.util.Enumeration;

public final class KDCReqBody
extends Sequence {
    private KDCOptions kdcOptions = null;
    private PrincipalName cname = null;
    private Realm realm = null;
    private PrincipalName sname = null;
    private KerberosTime from = null;
    private KerberosTime till = null;
    private KerberosTime rtime = null;
    private int nonce;
    private EncryptionType encType = null;
    private HostAddresses addresses = null;
    private EncryptedData encAuthData = null;
    private TicketsSeq addTickets = null;

    public KDCReqBody(KDCOptions kDCOptions, PrincipalName principalName, Realm realm, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int n, EncryptionType encryptionType, HostAddresses hostAddresses, EncryptedData encryptedData, TicketsSeq ticketsSeq) {
        Explicit explicit = new Explicit(-128, 0);
        this.kdcOptions = kDCOptions;
        explicit.addComponent(kDCOptions);
        this.addComponent(explicit);
        if (principalName != null) {
            this.cname = principalName;
            explicit = new Explicit(-128, 1);
            explicit.addComponent(principalName);
            this.addComponent(explicit);
        }
        this.realm = realm;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(this.realm);
        this.addComponent(explicit);
        explicit = new Explicit(-128, 3);
        explicit.addComponent(principalName2);
        this.addComponent(explicit);
        if (kerberosTime != null) {
            this.from = kerberosTime;
            explicit = new Explicit(-128, 4);
            explicit.addComponent(kerberosTime);
            this.addComponent(explicit);
        }
        this.till = kerberosTime2;
        explicit = new Explicit(-128, 5);
        explicit.addComponent(kerberosTime2);
        this.addComponent(explicit);
        if (kerberosTime3 != null) {
            this.rtime = kerberosTime3;
            explicit = new Explicit(-128, 6);
            explicit.addComponent(kerberosTime3);
            this.addComponent(explicit);
        }
        this.nonce = n;
        explicit = new Explicit(-128, 7);
        explicit.addComponent(new Integer(n));
        this.addComponent(explicit);
        explicit = new Explicit(-128, 8);
        this.encType = encryptionType;
        explicit.addComponent(encryptionType);
        this.addComponent(explicit);
        if (hostAddresses != null) {
            this.addresses = hostAddresses;
            explicit = new Explicit(-128, 9);
            explicit.addComponent(hostAddresses);
            this.addComponent(explicit);
        }
        if (encryptedData != null) {
            this.encAuthData = encryptedData;
            explicit = new Explicit(-128, 10);
            explicit.addComponent(encryptedData);
            this.addComponent(explicit);
        }
        if (ticketsSeq != null) {
            this.addTickets = ticketsSeq;
            explicit = new Explicit(-128, 11);
            explicit.addComponent(ticketsSeq);
            this.addComponent(explicit);
        }
    }

    public KDCReqBody(byte[] byArray) throws Asn1Exception, BadVersionException {
        this.doDecode(byArray);
        Enumeration enumeration = this.getComponents().elements();
        Explicit explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 0) {
            throw new Asn1Exception("Bad tag number");
        }
        this.kdcOptions = new KDCOptions(explicit.getComponent().encode());
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() == 1) {
            this.cname = new PrincipalName(explicit.getComponent().encode());
            explicit = (Explicit)enumeration.nextElement();
        }
        if (explicit.getTagNumber() != 2) {
            throw new Asn1Exception("Bad tag number");
        }
        this.realm = new Realm(explicit.getComponent().encode());
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() == 3) {
            this.sname = new PrincipalName(explicit.getComponent().encode());
            explicit = (Explicit)enumeration.nextElement();
        }
        if (explicit.getTagNumber() == 4) {
            this.from = new KerberosTime(explicit.getComponent().encode());
            explicit = (Explicit)enumeration.nextElement();
        }
        if (explicit.getTagNumber() == 5) {
            this.till = new KerberosTime(explicit.getComponent().encode());
            explicit = (Explicit)enumeration.nextElement();
        }
        if (explicit.getTagNumber() == 6) {
            this.rtime = new KerberosTime(explicit.getComponent().encode());
            explicit = (Explicit)enumeration.nextElement();
        }
        if (explicit.getTagNumber() != 7) {
            throw new Asn1Exception("Bad tag number");
        }
        this.nonce = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 8) {
            throw new Asn1Exception("Bad tag number");
        }
        this.encType = new EncryptionType(explicit.getComponent().encode());
        if (!enumeration.hasMoreElements()) {
            return;
        }
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() == 9) {
            this.addresses = new HostAddresses(explicit.getComponent().encode());
            if (enumeration.hasMoreElements()) {
                explicit = (Explicit)enumeration.nextElement();
            } else {
                return;
            }
        }
        if (explicit.getTagNumber() == 10) {
            this.encAuthData = new EncryptedData(explicit.getComponent().encode());
            if (enumeration.hasMoreElements()) {
                explicit = (Explicit)enumeration.nextElement();
            } else {
                return;
            }
        }
        if (explicit.getTagNumber() == 11) {
            this.addTickets = new TicketsSeq(explicit.getComponent().encode());
        }
    }

    public TicketsSeq getAdditionalTickets() {
        return this.addTickets;
    }

    public HostAddresses getClientAddresses() {
        return this.addresses;
    }

    public PrincipalName getClientName() {
        return this.cname;
    }

    public EncryptedData getEncAuthData() {
        return this.encAuthData;
    }

    public EncryptionType getEncryptionType() {
        return this.encType;
    }

    public KerberosTime getFrom() {
        return this.from;
    }

    public int getNonce() {
        return this.nonce;
    }

    public KDCOptions getOptions() {
        return this.kdcOptions;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public KerberosTime getRenewTill() {
        return this.rtime;
    }

    public PrincipalName getServerName() {
        return this.sname;
    }

    public KerberosTime getTill() {
        return this.till;
    }
}

