/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.KDCRep;

public final class KrbASRep
extends Explicit {
    public static final int TAG_KRB_AS_REP = 11;
    private KDCRep rep;

    public KrbASRep(KDCRep kDCRep) {
        super((byte)64, 11);
        this.rep = kDCRep;
        this.addComponent(kDCRep);
    }

    public KrbASRep(byte[] byArray) throws Asn1Exception, BadVersionException, BadMessageTypeException {
        this.doDecode(byArray);
        if (this.getTagNumber() != 11) {
            throw new BadMessageTypeException("Wrong tag for a KrbASRep");
        }
        this.rep = new KDCRep(this.getComponent().encode());
        if (this.rep.getMsgType() != 11) {
            throw new BadMessageTypeException("Wrong msgType in KrbASRep");
        }
    }

    public KDCRep getKDCRep() {
        return this.rep;
    }
}

