/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.TicketsSeq;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.util.Vector;

public final class KrbCred
extends Explicit {
    public static final int TAG_KRB_CRED = 22;
    private static final int pvno = 5;
    private int msgType = 22;
    private Vector tickets;
    private EncryptedData encPart;

    public KrbCred(Vector vector, EncryptedData encryptedData) {
        super((byte)64, 22);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(5));
        sequence.addComponent(explicit);
        explicit = new Explicit(-128, 1);
        explicit.addComponent(new Integer(this.msgType));
        sequence.addComponent(explicit);
        this.tickets = vector;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(new TicketsSeq(vector));
        sequence.addComponent(explicit);
        this.encPart = encryptedData;
        explicit = new Explicit(-128, 3);
        explicit.addComponent(encryptedData);
        sequence.addComponent(explicit);
        this.addComponent(sequence);
    }

    public KrbCred(byte[] byArray) throws Asn1Exception, BadVersionException, BadMessageTypeException {
        Explicit explicit;
        this.doDecode(byArray);
        if (this.getTagNumber() != 22) {
            throw new BadMessageTypeException("Wrong tag for a KrbCred");
        }
        Sequence sequence = (Sequence)this.getComponent();
        Vector vector = sequence.getComponents();
        int n = 0;
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag Number");
        }
        if (((Integer)explicit.getComponent()).getInt() != 5) {
            throw new BadVersionException("Bad version number");
        }
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        if (((Integer)explicit.getComponent()).getInt() != this.msgType) {
            throw new BadMessageTypeException("Bad msgType for a KrbCred");
        }
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag number");
        }
        TicketsSeq ticketsSeq = new TicketsSeq(explicit.getComponent().encode());
        this.tickets = ticketsSeq.getTickets();
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 3) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.encPart = new EncryptedData(explicit.getComponent().encode());
    }

    public EncryptedData getEncrypted() {
        return this.encPart;
    }

    public Vector getTickets() {
        return this.tickets;
    }
}

