/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.base.HostAddresses;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.base.TicketFlags;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;
import java.util.Enumeration;

public final class KrbCredInfo
extends Sequence {
    private EncryptionKey key = null;
    private Realm pRealm = null;
    private PrincipalName pName = null;
    private TicketFlags flags = null;
    private KerberosTime authTime = null;
    private KerberosTime startTime = null;
    private KerberosTime endTime = null;
    private KerberosTime renewTill = null;
    private Realm sRealm = null;
    private PrincipalName sName = null;
    private HostAddresses caddr = null;

    public KrbCredInfo(EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, Realm realm2, PrincipalName principalName2, HostAddresses hostAddresses) {
        this.key = encryptionKey;
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(encryptionKey);
        this.addComponent(explicit);
        if (realm != null) {
            this.pRealm = realm;
            explicit = new Explicit(-128, 1);
            explicit.addComponent(realm);
            this.addComponent(explicit);
        }
        if (principalName != null) {
            this.pName = principalName;
            explicit = new Explicit(-128, 2);
            explicit.addComponent(principalName);
            this.addComponent(explicit);
        }
        if (ticketFlags != null) {
            this.flags = ticketFlags;
            explicit = new Explicit(-128, 3);
            explicit.addComponent(ticketFlags);
            this.addComponent(explicit);
        }
        if (kerberosTime != null) {
            this.authTime = kerberosTime;
            explicit = new Explicit(-128, 4);
            explicit.addComponent(kerberosTime);
            this.addComponent(explicit);
        }
        if (kerberosTime2 != null) {
            this.startTime = kerberosTime2;
            explicit = new Explicit(-128, 5);
            explicit.addComponent(kerberosTime2);
            this.addComponent(explicit);
        }
        if (kerberosTime3 != null) {
            this.endTime = kerberosTime3;
            explicit = new Explicit(-128, 6);
            explicit.addComponent(kerberosTime3);
            this.addComponent(explicit);
        }
        if (kerberosTime4 != null) {
            this.renewTill = kerberosTime4;
            explicit = new Explicit(-128, 7);
            explicit.addComponent(kerberosTime4);
            this.addComponent(explicit);
        }
        if (realm2 != null) {
            this.sRealm = realm2;
            explicit = new Explicit(-128, 8);
            explicit.addComponent(realm2);
            this.addComponent(explicit);
        }
        if (principalName2 != null) {
            this.sName = principalName2;
            explicit = new Explicit(-128, 9);
            explicit.addComponent(principalName2);
            this.addComponent(explicit);
        }
        if (hostAddresses != null) {
            this.caddr = hostAddresses;
            explicit = new Explicit(-128, 10);
            explicit.addComponent(hostAddresses);
            this.addComponent(explicit);
        }
    }

    public KrbCredInfo(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        Enumeration enumeration = this.getComponents().elements();
        Explicit explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 0) {
            throw new Asn1Exception("Bad tag number");
        }
        this.key = new EncryptionKey(explicit.getComponent().encode());
        int n = 0;
        while (enumeration.hasMoreElements()) {
            explicit = (Explicit)enumeration.nextElement();
            int n2 = explicit.getTagNumber();
            if (n2 <= n) {
                throw new Asn1Exception("Sequence out of order");
            }
            n = n2;
            switch (n2) {
                case 1: {
                    this.pRealm = new Realm(explicit.getComponent().encode());
                    break;
                }
                case 2: {
                    this.pName = new PrincipalName(explicit.getComponent().encode());
                    break;
                }
                case 3: {
                    this.flags = new TicketFlags(explicit.getComponent().encode());
                    break;
                }
                case 4: {
                    this.authTime = new KerberosTime(explicit.getComponent().encode());
                    break;
                }
                case 5: {
                    this.startTime = new KerberosTime(explicit.getComponent().encode());
                    break;
                }
                case 6: {
                    this.endTime = new KerberosTime(explicit.getComponent().encode());
                    break;
                }
                case 7: {
                    this.renewTill = new KerberosTime(explicit.getComponent().encode());
                    break;
                }
                case 8: {
                    this.sRealm = new Realm(explicit.getComponent().encode());
                    break;
                }
                case 9: {
                    this.sName = new PrincipalName(explicit.getComponent().encode());
                    break;
                }
                case 10: {
                    this.caddr = new HostAddresses(explicit.getComponent().encode());
                    break;
                }
                default: {
                    throw new Asn1Exception("Invalid context tag number in sequence");
                }
            }
        }
    }
}

