/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import java.util.Vector;

public final class KrbError
extends Explicit {
    public static final int TAG_KRB_ERROR = 30;
    private int pvno;
    private int msgType;
    private KerberosTime ctime = null;
    private int cusec = 0;
    private KerberosTime stime;
    private int susec;
    private int errorCode;
    private Realm crealm = null;
    private PrincipalName cname = null;
    private Realm realm;
    private PrincipalName sname;
    private String eText = null;
    private byte[] eData = null;

    public KrbError(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        Sequence sequence = (Sequence)this.getComponent();
        Vector vector = sequence.getComponents();
        Explicit explicit = (Explicit)vector.elementAt(n++);
        this.pvno = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)vector.elementAt(n++);
        this.msgType = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)vector.elementAt(n);
        if (explicit.getTagNumber() == 2) {
            ++n;
            this.ctime = new KerberosTime(explicit.getComponent().encode());
        }
        if ((explicit = (Explicit)vector.elementAt(n)).getTagNumber() == 3) {
            this.cusec = ((Integer)explicit.getComponent()).getInt();
        }
        int n2 = ++n;
        explicit = (Explicit)vector.elementAt(n2);
        this.stime = new KerberosTime(explicit.getComponent().encode());
        int n3 = ++n;
        explicit = (Explicit)vector.elementAt(n3);
        this.susec = ((Integer)explicit.getComponent()).getInt();
        int n4 = ++n;
        explicit = (Explicit)vector.elementAt(n4);
        this.errorCode = ((Integer)explicit.getComponent()).getInt();
        if ((explicit = (Explicit)vector.elementAt(++n)).getTagNumber() == 7) {
            ++n;
            this.crealm = new Realm(explicit.getComponent().encode());
        }
        if ((explicit = (Explicit)vector.elementAt(n)).getTagNumber() == 8) {
            this.cname = new PrincipalName(explicit.getComponent().encode());
        }
        int n5 = ++n;
        explicit = (Explicit)vector.elementAt(n5);
        this.realm = new Realm(explicit.getComponent().encode());
        int n6 = ++n;
        explicit = (Explicit)vector.elementAt(n6);
        this.sname = new PrincipalName(explicit.getComponent().encode());
        if (++n == vector.size()) {
            return;
        }
        explicit = (Explicit)vector.elementAt(n);
        if (explicit.getTagNumber() == 11) {
            ++n;
            this.eText = ((GeneralString)explicit.getComponent()).getName();
        }
        if (n == vector.size()) {
            return;
        }
        explicit = (Explicit)vector.elementAt(n);
        if (explicit.getTagNumber() == 12) {
            ++n;
            this.eData = ((OctetString)explicit.getComponent()).getBytes();
        }
    }

    public String getMessage() {
        return this.eText;
    }
}

