/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.base;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import java.util.StringTokenizer;

public final class HostAddress
extends Sequence {
    private int addressType = 2;
    private byte[] address;

    public HostAddress(int n, byte[] byArray) {
        this.addressType = n;
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(this.addressType));
        this.addComponent(explicit);
        explicit = new Explicit(-128, 1);
        this.address = byArray;
        explicit.addComponent(new OctetString(byArray));
        this.addComponent(explicit);
    }

    public HostAddress(String string) {
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(this.addressType));
        this.addComponent(explicit);
        explicit = new Explicit(-128, 1);
        this.address = HostAddress.toIP(string);
        explicit.addComponent(new OctetString(this.address));
        this.addComponent(explicit);
    }

    public HostAddress(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        Explicit explicit = (Explicit)this.components.elementAt(0);
        if (explicit.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.addressType = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)this.components.elementAt(1);
        if (explicit.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.address = ((OctetString)explicit.getComponent()).getBytes();
    }

    public byte[] getAddress() {
        return this.address;
    }

    public int getAddressType() {
        return this.addressType;
    }

    private static final String ipToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(byArray[0]));
        int n = 1;
        while (n < byArray.length) {
            stringBuffer.append(".").append(String.valueOf(byArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final byte[] toIP(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)java.lang.Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        return byArray;
    }

    public String toString() {
        return HostAddress.ipToString(this.address);
    }
}

