/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.base;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import java.util.StringTokenizer;

public final class KDCOptions
extends BitString {
    public KDCOptions(String string) {
        this.contents = new byte[5];
        this.contents[0] = 0;
        this.contents[1] = 0;
        this.contents[2] = 0;
        this.contents[3] = 0;
        this.contents[4] = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toUpperCase();
            if (string2.equals("FORWARDABLE")) {
                this.contents[1] = (byte)(this.contents[1] | 0x40);
                continue;
            }
            if (string2.equals("FORWARDED")) {
                this.contents[1] = (byte)(this.contents[1] | 0x20);
                continue;
            }
            if (string2.equals("PROXIABLE")) {
                this.contents[1] = (byte)(this.contents[1] | 0x10);
                continue;
            }
            if (string2.equals("PROXY")) {
                this.contents[1] = (byte)(this.contents[1] | 8);
                continue;
            }
            if (string2.equals("ALLOW-POSTDATE")) {
                this.contents[1] = (byte)(this.contents[1] | 4);
                continue;
            }
            if (string2.equals("POSTDATED")) {
                this.contents[1] = (byte)(this.contents[1] | 2);
                continue;
            }
            if (string2.equals("RENEWABLE")) {
                this.contents[2] = (byte)(this.contents[2] | 0xFFFFFF80);
                continue;
            }
            if (string2.equals("DISABLE-TRANSITED-CHECK")) {
                this.contents[4] = (byte)(this.contents[4] | 0x20);
                continue;
            }
            if (string2.equals("RENEWABLE-OK")) {
                this.contents[4] = (byte)(this.contents[4] | 0x10);
                continue;
            }
            if (string2.equals("ENC-TKT-IN-SKEY")) {
                this.contents[4] = (byte)(this.contents[4] | 8);
                continue;
            }
            if (string2.equals("RENEW")) {
                this.contents[4] = (byte)(this.contents[4] | 2);
                continue;
            }
            if (!string2.equals("VALIDATE")) continue;
            this.contents[4] = (byte)(this.contents[4] | 1);
        }
    }

    public KDCOptions(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
    }

    public boolean isOn(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("FORWARDABLE")) {
            return (this.contents[1] & 0x40) != 0;
        }
        if (string2.equals("FORWARDED")) {
            return (this.contents[1] & 0x20) != 0;
        }
        if (string2.equals("PROXIABLE")) {
            return (this.contents[1] & 0x10) != 0;
        }
        if (string2.equals("PROXY")) {
            return (this.contents[1] & 8) != 0;
        }
        if (string2.equals("ALLOW-POSTDATE")) {
            return (this.contents[1] & 4) != 0;
        }
        if (string2.equals("POSTDATED")) {
            return (this.contents[1] & 2) != 0;
        }
        if (string2.equals("RENEWABLE")) {
            return (this.contents[2] & 0xFFFFFF80) != 0;
        }
        if (string2.equals("DISABLE-TRANSITED-CHECK")) {
            return (this.contents[4] & 0x20) != 0;
        }
        if (string2.equals("RENEWABLE-OK")) {
            return (this.contents[4] & 0x10) != 0;
        }
        if (string2.equals("ENC-TKT-IN-SKEY")) {
            return (this.contents[4] & 8) != 0;
        }
        if (string2.equals("RENEW")) {
            return (this.contents[4] & 2) != 0;
        }
        if (string2.equals("VALIDATE")) {
            return (this.contents[4] & 1) != 0;
        }
        return false;
    }

    public void setOn(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("FORWARDABLE")) {
            this.contents[1] = (byte)(this.contents[1] | 0x40);
        } else if (string2.equals("FORWARDED")) {
            this.contents[1] = (byte)(this.contents[1] | 0x20);
        } else if (string2.equals("PROXIABLE")) {
            this.contents[1] = (byte)(this.contents[1] | 0x10);
        } else if (string2.equals("PROXY")) {
            this.contents[1] = (byte)(this.contents[1] | 8);
        } else if (string2.equals("ALLOW-POSTDATE")) {
            this.contents[1] = (byte)(this.contents[1] | 4);
        } else if (string2.equals("POSTDATED")) {
            this.contents[1] = (byte)(this.contents[1] | 2);
        } else if (string2.equals("RENEWABLE")) {
            this.contents[2] = (byte)(this.contents[2] | 0xFFFFFF80);
        } else if (string2.equals("DISABLE-TRANSITED-CHECK")) {
            this.contents[4] = (byte)(this.contents[4] | 0x20);
        } else if (string2.equals("RENEWABLE-OK")) {
            this.contents[4] = (byte)(this.contents[4] | 0x10);
        } else if (string2.equals("ENC-TKT-IN-SKEY")) {
            this.contents[4] = (byte)(this.contents[4] | 8);
        } else if (string2.equals("RENEW")) {
            this.contents[4] = (byte)(this.contents[4] | 2);
        } else if (string2.equals("VALIDATE")) {
            this.contents[4] = (byte)(this.contents[4] | 1);
        }
    }
}

