/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.base;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.GeneralizedTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class KerberosTime
extends GeneralizedTime {
    public KerberosTime() {
        this.contents = this.getTime(null, 0).getBytes();
    }

    public KerberosTime(int n) {
        this.contents = this.getTime(null, n).getBytes();
    }

    public KerberosTime(Date date) {
        this.contents = this.getTime(date, 0).getBytes();
    }

    public KerberosTime(Date date, int n) {
        this.contents = this.getTime(date, n).getBytes();
    }

    public KerberosTime(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
    }

    private void append(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append("0" + n);
        } else {
            stringBuffer.append(n);
        }
    }

    public static KerberosTime getCurrent() {
        return new KerberosTime(0);
    }

    public Date getDate() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.set(Integer.parseInt(new String(this.contents, 0, 4)), Integer.parseInt(new String(this.contents, 4, 2)) - 1, Integer.parseInt(new String(this.contents, 6, 2)), Integer.parseInt(new String(this.contents, 8, 2)), Integer.parseInt(new String(this.contents, 10, 2)), Integer.parseInt(new String(this.contents, 12, 2)));
        return calendar.getTime();
    }

    private String getTime(Date date, int n) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(11, n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(calendar.get(1));
        this.append(stringBuffer, calendar.get(2) + 1);
        this.append(stringBuffer, calendar.get(5));
        this.append(stringBuffer, calendar.get(11));
        this.append(stringBuffer, calendar.get(12));
        this.append(stringBuffer, calendar.get(13));
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }
}

