/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.base;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public final class PrincipalName
extends Sequence {
    public static final int NT_UNKNOWN = 0;
    public static final int NT_PRINCIPAL = 1;
    public static final int NT_SRV_INST = 2;
    public static final int NT_SRV_HST = 3;
    public static final int NT_SRV_XHST = 4;
    public static final int NT_UID = 5;
    private int nameType;
    private NameString ns;

    public PrincipalName(int n, Vector vector) {
        this.nameType = n;
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(n));
        this.addComponent(explicit);
        explicit = new Explicit(-128, 1);
        this.ns = new NameString(vector);
        explicit.addComponent(this.ns);
        this.addComponent(explicit);
    }

    public PrincipalName(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        Explicit explicit = (Explicit)this.components.elementAt(0);
        if (explicit.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.nameType = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)this.components.elementAt(1);
        if (explicit.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.ns = new NameString(((Sequence)explicit.getComponent()).encode());
    }

    public Vector getNameString() {
        return this.ns.nameString;
    }

    public int getNameType() {
        return this.nameType;
    }

    public String toString() {
        Iterator iterator = ((AbstractList)this.ns.nameString).iterator();
        StringBuffer stringBuffer = new StringBuffer((String)iterator.next());
        while (iterator.hasNext()) {
            stringBuffer.append("/").append(iterator.next());
        }
        return stringBuffer.toString();
    }

    protected class NameString
    extends Sequence {
        private Vector nameString;

        protected NameString(Vector vector) {
            this.nameString = vector;
            int n = 0;
            while (n < vector.size()) {
                this.addComponent(new GeneralString((String)vector.elementAt(n)));
                ++n;
            }
        }

        protected NameString(byte[] byArray) throws Asn1Exception {
            this.nameString = new Vector();
            this.doDecode(byArray);
            int n = 0;
            while (n < this.components.size()) {
                this.nameString.addElement(((GeneralString)this.components.elementAt(n)).getName());
                ++n;
            }
        }
    }
}

