/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.base;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import java.util.StringTokenizer;

public final class TicketFlags
extends BitString {
    public TicketFlags(int n) {
        this.contents = new byte[5];
        this.contents[0] = 0;
        this.contents[1] = (byte)(n >> 24 & 0xFF);
        this.contents[2] = (byte)(n >> 16 & 0xFF);
        this.contents[3] = (byte)(n >> 8 & 0xFF);
        this.contents[4] = (byte)(n & 0xFF);
    }

    public TicketFlags(String string) {
        this.contents = new byte[5];
        this.contents[0] = 0;
        this.contents[1] = 0;
        this.contents[2] = 0;
        this.contents[3] = 0;
        this.contents[4] = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r\f,");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toUpperCase();
            if (string2.equals("FORWARDABLE")) {
                this.contents[1] = (byte)(this.contents[1] | 0x40);
                continue;
            }
            if (string2.equals("FORWARDED")) {
                this.contents[1] = (byte)(this.contents[1] | 0x20);
                continue;
            }
            if (string2.equals("PROXIABLE")) {
                this.contents[1] = (byte)(this.contents[1] | 0x10);
                continue;
            }
            if (string2.equals("PROXY")) {
                this.contents[1] = (byte)(this.contents[1] | 8);
                continue;
            }
            if (string2.equals("MAY-POSTDATE")) {
                this.contents[1] = (byte)(this.contents[1] | 4);
                continue;
            }
            if (string2.equals("POSTDATED")) {
                this.contents[1] = (byte)(this.contents[1] | 2);
                continue;
            }
            if (string2.equals("INVALID")) {
                this.contents[1] = (byte)(this.contents[1] | 1);
                continue;
            }
            if (string2.equals("RENEWABLE")) {
                this.contents[2] = (byte)(this.contents[2] | 0xFFFFFF80);
                continue;
            }
            if (string2.equals("INITIAL")) {
                this.contents[2] = (byte)(this.contents[2] | 0x40);
                continue;
            }
            if (string2.equals("PRE-AUTHENT")) {
                this.contents[2] = (byte)(this.contents[2] | 0x20);
                continue;
            }
            if (string2.equals("HW-AUTHENT")) {
                this.contents[2] = (byte)(this.contents[2] | 0x10);
                continue;
            }
            if (string2.equals("TRANSITED-POLICY-CHECKED")) {
                this.contents[2] = (byte)(this.contents[2] | 8);
                continue;
            }
            if (string2.equals("OK-AS-DELEGATE")) {
                this.contents[2] = (byte)(this.contents[2] | 4);
                continue;
            }
            if (!string2.equals("ANONYMOUS")) continue;
            this.contents[2] = (byte)(this.contents[2] | 2);
        }
    }

    public TicketFlags(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, boolean bl14) {
        this.contents = new byte[5];
        this.contents[0] = 0;
        this.contents[1] = 0;
        this.contents[2] = 0;
        this.contents[3] = 0;
        this.contents[4] = 0;
        if (bl) {
            this.contents[1] = (byte)(this.contents[1] | 0x40);
        }
        if (bl2) {
            this.contents[1] = (byte)(this.contents[1] | 0x20);
        }
        if (bl3) {
            this.contents[1] = (byte)(this.contents[1] | 0x10);
        }
        if (bl4) {
            this.contents[1] = (byte)(this.contents[1] | 8);
        }
        if (bl5) {
            this.contents[1] = (byte)(this.contents[1] | 4);
        }
        if (bl6) {
            this.contents[1] = (byte)(this.contents[1] | 2);
        }
        if (bl7) {
            this.contents[1] = (byte)(this.contents[1] | 1);
        }
        if (bl8) {
            this.contents[2] = (byte)(this.contents[2] | 0xFFFFFF80);
        }
        if (bl9) {
            this.contents[2] = (byte)(this.contents[2] | 0x40);
        }
        if (bl10) {
            this.contents[2] = (byte)(this.contents[2] | 0x20);
        }
        if (bl11) {
            this.contents[2] = (byte)(this.contents[2] | 0x10);
        }
        if (bl12) {
            this.contents[2] = (byte)(this.contents[2] | 8);
        }
        if (bl13) {
            this.contents[2] = (byte)(this.contents[2] | 4);
        }
        if (bl14) {
            this.contents[2] = (byte)(this.contents[2] | 2);
        }
    }

    public TicketFlags(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
    }

    public byte[] getFlags() {
        return this.getBytes();
    }

    public int getFlagsMask() {
        byte[] byArray = this.getBytes();
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        return n;
    }

    public boolean isOn(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("FORWARDABLE")) {
            return (this.contents[1] & 0x40) != 0;
        }
        if (string2.equals("FORWARDED")) {
            return (this.contents[1] & 0x20) != 0;
        }
        if (string2.equals("PROXIABLE")) {
            return (this.contents[1] & 0x10) != 0;
        }
        if (string2.equals("PROXY")) {
            return (this.contents[1] & 8) != 0;
        }
        if (string2.equals("MAY-POSTDATE")) {
            return (this.contents[1] & 4) != 0;
        }
        if (string2.equals("POSTDATED")) {
            return (this.contents[1] & 2) != 0;
        }
        if (string2.equals("INVALID")) {
            return (this.contents[2] & 1) != 0;
        }
        if (string2.equals("RENEWABLE")) {
            return (this.contents[2] & 0xFFFFFF80) != 0;
        }
        if (string2.equals("INITIAL")) {
            return (this.contents[2] & 0x40) != 0;
        }
        if (string2.equals("PRE-AUTHENT")) {
            return (this.contents[2] & 0x20) != 0;
        }
        if (string2.equals("HW-AUTHENT")) {
            return (this.contents[2] & 0x10) != 0;
        }
        if (string2.equals("TRANSITED-POLICY-CHECKED")) {
            return (this.contents[2] & 8) != 0;
        }
        if (string2.equals("OK-AS-DELEGATE")) {
            return (this.contents[2] & 4) != 0;
        }
        if (string2.equals("ANONYMOUS")) {
            return (this.contents[2] & 2) != 0;
        }
        return false;
    }
}

