/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.creds;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.base.AuthorizationData;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.crypto.Checksum;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;
import java.util.Enumeration;

public final class Authenticator
extends Explicit {
    public static final int TAG_KRB_AUTHENTICATOR = 2;
    private static final int pvno = 5;
    private Realm crealm;
    private PrincipalName cName;
    private Checksum cksum;
    private int cusec;
    private KerberosTime ctime;
    private EncryptionKey subkey;
    private int seqNum = -1;
    private AuthorizationData authData;

    public Authenticator(Realm realm, PrincipalName principalName, Checksum checksum, int n, KerberosTime kerberosTime, EncryptionKey encryptionKey, int n2, AuthorizationData authorizationData) {
        super((byte)64, 2);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(5));
        sequence.addComponent(explicit);
        this.crealm = realm;
        explicit = new Explicit(-128, 1);
        explicit.addComponent(realm);
        sequence.addComponent(explicit);
        this.cName = principalName;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(principalName);
        sequence.addComponent(explicit);
        if (checksum != null) {
            this.cksum = checksum;
            explicit = new Explicit(-128, 3);
            explicit.addComponent(checksum);
            sequence.addComponent(explicit);
        }
        this.cusec = n;
        explicit = new Explicit(-128, 4);
        explicit.addComponent(new Integer(n));
        sequence.addComponent(explicit);
        this.ctime = kerberosTime;
        explicit = new Explicit(-128, 5);
        explicit.addComponent(kerberosTime);
        sequence.addComponent(explicit);
        if (encryptionKey != null) {
            this.subkey = encryptionKey;
            explicit = new Explicit(-128, 6);
            explicit.addComponent(encryptionKey);
            sequence.addComponent(explicit);
        }
        if (n2 >= 0) {
            this.seqNum = n2;
            explicit = new Explicit(-128, 7);
            explicit.addComponent(new Integer(n2));
            sequence.addComponent(explicit);
        }
        if (authorizationData != null) {
            this.authData = authorizationData;
            explicit = new Explicit(-128, 8);
            explicit.addComponent(authorizationData);
            sequence.addComponent(explicit);
        }
        this.addComponent(sequence);
    }

    public Authenticator(byte[] byArray) throws Asn1Exception, BadVersionException {
        this.doDecode(byArray);
        if (this.getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag Number");
        }
        Sequence sequence = (Sequence)this.getComponent();
        Enumeration enumeration = sequence.getComponents().elements();
        Explicit explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag Number");
        }
        if (((Integer)explicit.getComponent()).getInt() != 5) {
            throw new BadVersionException("Not version 5");
        }
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.crealm = new Realm(explicit.getComponent().encode());
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cName = new PrincipalName(explicit.getComponent().encode());
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() == 3) {
            this.cksum = new Checksum(explicit.getComponent().encode());
            explicit = (Explicit)enumeration.nextElement();
        }
        if (explicit.getTagNumber() != 4) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cusec = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)enumeration.nextElement();
        if (explicit.getTagNumber() != 5) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.ctime = new KerberosTime(explicit.getComponent().encode());
        int n = 5;
        while (enumeration.hasMoreElements()) {
            explicit = (Explicit)enumeration.nextElement();
            int n2 = explicit.getTagNumber();
            if (n2 <= n) {
                throw new Asn1Exception("Sequence out of order");
            }
            n = n2;
            switch (n2) {
                case 6: {
                    this.subkey = new EncryptionKey(explicit.getComponent().encode());
                    break;
                }
                case 7: {
                    this.seqNum = ((Integer)explicit.getComponent()).getInt();
                    break;
                }
                case 8: {
                    this.authData = new AuthorizationData(explicit.getComponent().encode());
                    break;
                }
                default: {
                    throw new Asn1Exception("Invalid context tag number in sequence");
                }
            }
        }
    }

    public AuthorizationData getAuthData() {
        return this.authData;
    }

    public KerberosTime getCTime() {
        return this.ctime;
    }

    public Checksum getChecksum() {
        return this.cksum;
    }

    public PrincipalName getClientName() {
        return this.cName;
    }

    public int getCusec() {
        return this.cusec;
    }

    public Realm getRealm() {
        return this.crealm;
    }

    public int getSeqNumber() {
        return this.seqNum;
    }

    public EncryptionKey getSubKey() {
        return this.subkey;
    }
}

