/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.creds;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.base.HostAddresses;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.base.TicketFlags;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;
import java.util.Vector;

public final class EncTicketPart
extends Explicit {
    public static final int TAG_KRB_ENC_TICKET = 3;
    private TicketFlags ticketFlags;
    private EncryptionKey key;
    private Realm crealm;
    private PrincipalName cName;
    private KerberosTime authtime;
    private KerberosTime starttime;
    private KerberosTime endtime;
    private KerberosTime renewTill;
    private HostAddresses caddr;

    public EncTicketPart(byte[] byArray) throws Asn1Exception {
        Explicit explicit;
        this.doDecode(byArray);
        if (this.getTagNumber() != 3) {
            throw new Asn1Exception("Bad Tag number");
        }
        Sequence sequence = (Sequence)this.getComponent();
        Vector vector = sequence.getComponents();
        int n = 0;
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag Number");
        }
        this.ticketFlags = new TicketFlags(explicit.getComponent().encode());
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.key = new EncryptionKey(explicit.getComponent().encode());
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.crealm = new Realm(explicit.getComponent().encode());
        if ((explicit = (Explicit)vector.elementAt(n++)).getTagNumber() != 3) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cName = new PrincipalName(explicit.getComponent().encode());
        int n2 = ++n;
        ++n;
        explicit = (Explicit)vector.elementAt(n2);
        if (explicit.getTagNumber() != 5) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.authtime = new KerberosTime(explicit.getComponent().encode());
        explicit = (Explicit)vector.elementAt(n);
        if (explicit.getTagNumber() == 6) {
            this.starttime = new KerberosTime(explicit.getComponent().encode());
        }
        int n3 = ++n;
        ++n;
        explicit = (Explicit)vector.elementAt(n3);
        if (explicit.getTagNumber() != 7) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.endtime = new KerberosTime(explicit.getComponent().encode());
        if (n == vector.size()) {
            return;
        }
        explicit = (Explicit)vector.elementAt(n);
        if (explicit.getTagNumber() == 8) {
            this.renewTill = new KerberosTime(explicit.getComponent().encode());
            ++n;
        }
        if (n == vector.size()) {
            return;
        }
        explicit = (Explicit)vector.elementAt(n);
        if (explicit.getTagNumber() == 9) {
            this.caddr = new HostAddresses(explicit.getComponent().encode());
            ++n;
        }
    }

    public PrincipalName getClientName() {
        return this.cName;
    }

    public EncryptionKey getKey() {
        return this.key;
    }

    public Realm getRealm() {
        return this.crealm;
    }
}

