/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.creds;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.util.Vector;

public final class Ticket
extends Explicit {
    public static final int TAG_KRB_TICKET = 1;
    public static final int tktVno = 5;
    private Realm realm;
    private PrincipalName sName;
    private EncryptedData encPart;

    public Ticket(Realm realm, PrincipalName principalName, EncryptedData encryptedData) {
        super((byte)64, 1);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(5));
        sequence.addComponent(explicit);
        this.realm = realm;
        explicit = new Explicit(-128, 1);
        explicit.addComponent(realm);
        sequence.addComponent(explicit);
        this.sName = principalName;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(principalName);
        sequence.addComponent(explicit);
        this.encPart = encryptedData;
        explicit = new Explicit(-128, 3);
        explicit.addComponent(encryptedData);
        sequence.addComponent(explicit);
        this.addComponent(sequence);
    }

    public Ticket(byte[] byArray) throws Asn1Exception, BadVersionException {
        this.doDecode(byArray);
        Sequence sequence = (Sequence)this.getComponent();
        Vector vector = sequence.getComponents();
        Explicit explicit = (Explicit)vector.elementAt(0);
        if (explicit.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag Number");
        }
        if (((Integer)explicit.getComponent()).getInt() != 5) {
            throw new BadVersionException("Not version 5");
        }
        explicit = (Explicit)vector.elementAt(1);
        if (explicit.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.realm = new Realm(explicit.getComponent().encode());
        explicit = (Explicit)vector.elementAt(2);
        if (explicit.getTagNumber() != 2) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.sName = new PrincipalName(explicit.getComponent().encode());
        explicit = (Explicit)vector.elementAt(3);
        if (explicit.getTagNumber() != 3) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.encPart = new EncryptedData(explicit.getComponent().encode());
    }

    public EncryptedData getEncrypted() {
        return this.encPart;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public PrincipalName getServerName() {
        return this.sName;
    }
}

