/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.crypto;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;

public final class Checksum
extends Sequence {
    private int cksumType;
    private byte[] cksum;

    public Checksum(int n, byte[] byArray) {
        this.cksumType = n;
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(n));
        this.addComponent(explicit);
        this.cksum = byArray;
        explicit = new Explicit(-128, 1);
        explicit.addComponent(new OctetString(byArray));
        this.addComponent(explicit);
    }

    public Checksum(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        Explicit explicit = (Explicit)this.components.elementAt(0);
        if (explicit.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cksumType = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)this.components.elementAt(1);
        if (explicit.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.cksum = ((OctetString)explicit.getComponent()).getBytes();
    }

    public byte[] getBytes() {
        return this.cksum;
    }

    public int getType() {
        return this.cksumType;
    }
}

