/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.crypto;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;

public final class EncryptedData
extends Sequence {
    private int eType;
    private int kvno;
    private byte[] cipherText;

    public EncryptedData(int n, int n2, byte[] byArray) {
        this.eType = n;
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(n));
        this.addComponent(explicit);
        this.kvno = n2;
        explicit = new Explicit(-128, 1);
        explicit.addComponent(new Integer(n2));
        this.addComponent(explicit);
        this.cipherText = byArray;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(new OctetString(byArray));
        this.addComponent(explicit);
    }

    public EncryptedData(int n, byte[] byArray) {
        this.eType = n;
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(n));
        this.addComponent(explicit);
        this.cipherText = byArray;
        explicit = new Explicit(-128, 2);
        explicit.addComponent(new OctetString(byArray));
        this.addComponent(explicit);
    }

    public EncryptedData(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        Explicit explicit = (Explicit)this.components.elementAt(n++);
        if (explicit.getTagNumber() == 0) {
            this.eType = ((Integer)explicit.getComponent()).getInt();
        }
        if ((explicit = (Explicit)this.components.elementAt(n)).getTagNumber() == 1) {
            this.kvno = ((Integer)explicit.getComponent()).getInt();
            ++n;
        }
        if ((explicit = (Explicit)this.components.elementAt(n)).getTagNumber() == 2) {
            this.cipherText = ((OctetString)explicit.getComponent()).getBytes();
        }
    }

    public byte[] getCipherText() {
        return (byte[])this.cipherText.clone();
    }

    public int getEncryptionType() {
        return this.eType;
    }
}

