/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.v5.crypto;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;

public final class EncryptionKey
extends Sequence {
    private int keyType;
    private byte[] keyValue;

    public EncryptionKey(int n, byte[] byArray) {
        this.keyType = n;
        Explicit explicit = new Explicit(-128, 0);
        explicit.addComponent(new Integer(n));
        this.addComponent(explicit);
        this.keyValue = byArray;
        explicit = new Explicit(-128, 1);
        explicit.addComponent(new OctetString(byArray));
        this.addComponent(explicit);
    }

    public EncryptionKey(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        Explicit explicit = (Explicit)this.components.elementAt(0);
        if (explicit.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.keyType = ((Integer)explicit.getComponent()).getInt();
        explicit = (Explicit)this.components.elementAt(1);
        if (explicit.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.keyValue = ((OctetString)explicit.getComponent()).getBytes();
    }

    public byte[] getKeyBytes() {
        return this.keyValue;
    }

    public int getKeyType() {
        return this.keyType;
    }
}

