/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pkcs8;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.AlgorithmId;

public class EncryptedPrivateKeyInfo
extends Sequence {
    private AlgorithmId encAlgo;
    private byte[] encryptedKey;

    public EncryptedPrivateKeyInfo(AlgorithmId algorithmId, byte[] byArray) {
        this.encAlgo = algorithmId;
        this.addComponent(algorithmId);
        this.encryptedKey = byArray;
        this.addComponent(new OctetString(byArray));
    }

    public EncryptedPrivateKeyInfo(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.encAlgo = new AlgorithmId(((Sequence)this.components.elementAt(0)).encode());
        this.encryptedKey = ((OctetString)this.components.elementAt(1)).getBytes();
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public AlgorithmId getEncryptionAlgorithm() {
        return this.encAlgo;
    }
}

