/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pkcs8;

import com.dstc.security.provider.PBEKey;
import com.dstc.security.provider.PBEKeyDerivation;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS5KeyDerivation
implements PBEKeyDerivation {
    public byte[] generateKey(int n, MessageDigest messageDigest, Key key, AlgorithmParameterSpec algorithmParameterSpec, int n2) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Unrecognise or unsupported Mode");
        }
        if (messageDigest == null) {
            throw new NullPointerException("Message Digest not initialised");
        }
        if (!(key instanceof PBEKey)) {
            throw new InvalidKeyException("Not a PBE Key");
        }
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not PBE parameters");
        }
        if (n2 != 8) {
            throw new IllegalArgumentException("Expecting Key Length to be 8 bytes");
        }
        byte[] byArray = new byte[n2];
        byte[] byArray2 = ((PBEKey)key).getEncoded();
        byte[] byArray3 = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
        int n3 = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
        int n4 = 0;
        while (n4 < n3) {
            messageDigest.update(byArray4);
            byArray4 = messageDigest.digest();
            ++n4;
        }
        if (n == 1) {
            System.arraycopy(byArray4, 0, byArray, 0, byArray.length);
        } else if (n == 2) {
            System.arraycopy(byArray4, byArray4.length - 8, byArray, 0, byArray.length);
        } else {
            throw new IllegalArgumentException("Unrecogisned or unsupported mode");
        }
        return byArray;
    }
}

