/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pkcs8;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.pkcs12.PKCS12KeyDerivation;
import com.dstc.security.pkcs8.EncryptedPrivateKeyInfo;
import com.dstc.security.pkcs8.PKCS5KeyDerivation;
import com.dstc.security.pkcs8.PrivateKeyInfo;
import com.dstc.security.provider.DHPrivateKey;
import com.dstc.security.provider.DSAPrivateKey;
import com.dstc.security.provider.PBEKey;
import com.dstc.security.provider.PBEKeyDerivation;
import com.dstc.security.provider.RSAPrivateCrtKey;
import com.dstc.security.x509.AlgorithmId;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.PrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS8EncryptedPrivateKey {
    private EncryptedPrivateKeyInfo epki = null;
    private PrivateKey priv = null;

    public PKCS8EncryptedPrivateKey(PrivateKey privateKey) {
        this.priv = privateKey;
    }

    public PKCS8EncryptedPrivateKey(byte[] byArray) throws Asn1Exception {
        this.epki = new EncryptedPrivateKeyInfo(byArray);
    }

    public void decrypt(String string) throws InvalidKeySpecException {
        this.decrypt(string.getBytes());
    }

    public void decrypt(String string, PBEKeyDerivation pBEKeyDerivation) throws InvalidKeySpecException {
        if (pBEKeyDerivation instanceof PKCS5KeyDerivation) {
            this.decrypt(string.getBytes());
        } else if (pBEKeyDerivation instanceof PKCS12KeyDerivation) {
            try {
                byte[] byArray = string.getBytes("UnicodeBigUnmarked");
                byte[] byArray2 = new byte[byArray.length + 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray2[byArray.length] = 0;
                byArray2[byArray.length + 1] = 0;
                this.decrypt(byArray2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Unsupported PBEKeyDerivation");
        }
    }

    public void decrypt(byte[] byArray) throws InvalidKeySpecException {
        try {
            byte[] byArray2 = this.epki.getEncryptedKey();
            AlgorithmId algorithmId = this.epki.getEncryptionAlgorithm();
            Cipher cipher = null;
            if (algorithmId.getOid().equals("1.2.840.113549.1.5.3")) {
                cipher = Cipher.getInstance("PBEwithMD5andDES-CBC");
            } else if (algorithmId.getOid().equals("1.2.840.113549.1.12.1.3")) {
                cipher = Cipher.getInstance("PBEwithSHAand3-KeyTripleDES-CBC");
            } else {
                throw new InvalidKeySpecException("Unknown encryption algorithm!!");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmId.getParams().getParameterSpec(Class.forName("javax.crypto.spec.PBEParameterSpec"));
            PBEKey pBEKey = new PBEKey(byArray);
            cipher.init(2, pBEKey, pBEParameterSpec, null);
            byte[] byArray3 = cipher.doFinal(byArray2);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(byArray3);
            AlgorithmId algorithmId2 = privateKeyInfo.getAlgorithmId();
            if (algorithmId2.getOid().equals("1.2.840.113549.1.1.1")) {
                this.priv = new RSAPrivateCrtKey(privateKeyInfo.getEncodedKey());
            } else if (algorithmId2.getOid().equals("1.2.840.10040.4.1")) {
                DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmId2.getParams().getParameterSpec(Class.forName("java.security.spec.DSAParameterSpec"));
                this.priv = new DSAPrivateKey(privateKeyInfo.getEncodedKey(), dSAParameterSpec);
            } else if (algorithmId2.getOid().equals("1.2.840.113549.1.3.1")) {
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmId2.getParams().getParameterSpec(Class.forName("javax.crypto.spec.DHParameterSpec"));
                this.priv = new DHPrivateKey(privateKeyInfo.getEncodedKey(), dHParameterSpec);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void encrypt(String string) {
        this.encrypt(string.getBytes(), (PBEKeyDerivation)new PKCS5KeyDerivation());
    }

    public void encrypt(String string, PBEKeyDerivation pBEKeyDerivation) {
        if (pBEKeyDerivation instanceof PKCS5KeyDerivation) {
            this.encrypt(string.getBytes(), pBEKeyDerivation);
        } else if (pBEKeyDerivation instanceof PKCS12KeyDerivation) {
            try {
                byte[] byArray = string.getBytes("UnicodeBigUnmarked");
                byte[] byArray2 = new byte[byArray.length + 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray2[byArray.length] = 0;
                byArray2[byArray.length + 1] = 0;
                this.encrypt(byArray2, pBEKeyDerivation);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Unsupported PBEKeyDerivation");
        }
    }

    public void encrypt(byte[] byArray) {
        this.encrypt(byArray, (PBEKeyDerivation)new PKCS5KeyDerivation());
    }

    public void encrypt(byte[] byArray, PBEKeyDerivation pBEKeyDerivation) {
        try {
            byte[] byArray2 = "Hello there!".getBytes();
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            PBEKey pBEKey = new PBEKey(byArray);
            PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(byArray3, 5);
            AlgorithmParameters algorithmParameters = null;
            Cipher cipher = null;
            if (pBEKeyDerivation instanceof PKCS5KeyDerivation) {
                algorithmParameters = AlgorithmParameters.getInstance("PBEwithMD5andDES-CBC");
                cipher = Cipher.getInstance("PBEwithMD5andDES-CBC");
            } else if (pBEKeyDerivation instanceof PKCS12KeyDerivation) {
                algorithmParameters = AlgorithmParameters.getInstance("PBEwithSHAand3-KeyTripleDES-CBC");
                cipher = Cipher.getInstance("PBEwithSHAand3-KeyTripleDES-CBC");
            } else {
                throw new Exception("Unsupported PBEKeyDerivation style");
            }
            algorithmParameters.init(pBEParameterSpec);
            cipher.init(1, (Key)pBEKey, pBEParameterSpec);
            byte[] byArray4 = this.priv.getEncoded();
            byte[] byArray5 = cipher.doFinal(byArray4);
            this.epki = new EncryptedPrivateKeyInfo(new AlgorithmId("1.2.840.113549.1.5.3", algorithmParameters), byArray5);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte[] getEncoded() {
        return this.epki.encode();
    }

    public PrivateKey getPrivateKey() {
        return this.priv;
    }
}

