/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.cms.v1.ContentInfo;
import com.dstc.security.cms.v1.EncapContentInfo;
import com.dstc.security.cms.v1.SignedData;
import com.dstc.security.pki.CertRequestFactory;
import com.dstc.security.pki.pkcs10.PKCS10CertificationRequest;
import com.dstc.security.x509.Attribute;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.ExtensionFactory;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import com.dstc.security.x509.Validity;
import com.dstc.security.x509.X500Name;
import com.dstc.security.x509.X509CRLImpl;
import com.dstc.security.x509.X509CertImpl;
import com.dstc.security.x509.extns.AuthorityKeyIdentifier;
import com.dstc.security.x509.extns.SubjectAltName;
import com.dstc.security.x509.extns.SubjectKeyIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class CertGenerator {
    protected static final int UNINITIALIZED = 0;
    protected static final int INITIALIZED = 1;
    private int state = 0;
    private int validityPeriod = 100;
    private String sigAlgName;
    private X500Name issuer;
    private PrivateKey caPrivateKey;
    private byte[] caSubjectKeyId = null;
    private X509Certificate caCert;
    private PublicKey subjectPubKey;
    private String subjectName;
    private String email;
    private Vector extns;

    public void addExtension(Extension extension) {
        if (this.extns == null) {
            this.extns = new Vector();
        }
        this.extns.add(extension);
    }

    public X509CRL generateCRL(UTCTime uTCTime, UTCTime uTCTime2, Set set) throws ToolException {
        try {
            X509CRLImpl x509CRLImpl = new X509CRLImpl(this.sigAlgName, this.issuer, uTCTime, uTCTime2, set, null, this.caPrivateKey);
            return x509CRLImpl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public X509Certificate generateCertificate(int n, BigInteger bigInteger) throws ToolException {
        if (this.subjectPubKey == null) {
            throw new ToolException("Subject Public key not yet set");
        }
        if (this.subjectName == null) {
            throw new ToolException("Subject Distinguished Name not yet set");
        }
        try {
            Validity validity = new Validity(this.validityPeriod);
            X500Name x500Name = new X500Name(this.subjectName);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(this.subjectPubKey.getEncoded());
            if (this.email != null) {
                this.addExtension(new SubjectAltName(this.email));
            }
            if (this.caSubjectKeyId != null) {
                this.addExtension(new AuthorityKeyIdentifier(true, this.caSubjectKeyId));
            }
            X509CertImpl x509CertImpl = new X509CertImpl(n, bigInteger, this.issuer, validity, x500Name, subjectPublicKeyInfo, this.sigAlgName, this.caPrivateKey, new Extensions(this.extns));
            this.resetSubjectInfo();
            return x509CertImpl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void init(PrivateKey privateKey, X509Certificate x509Certificate) throws ToolException {
        try {
            this.caPrivateKey = privateKey;
            if (x509Certificate != null) {
                this.caCert = x509Certificate;
                SubjectKeyIdentifier subjectKeyIdentifier = (SubjectKeyIdentifier)ExtensionFactory.getExtension("2.5.29.14", x509Certificate);
                if (subjectKeyIdentifier != null) {
                    this.caSubjectKeyId = subjectKeyIdentifier.getKeyID();
                }
            }
            this.state = 1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public boolean isInitialized() {
        return this.state == 1;
    }

    public ContentInfo makeCertChain(X509Certificate x509Certificate) {
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        hashSet.add(this.caCert);
        hashSet.add(x509Certificate);
        SignedData signedData = new SignedData(new HashSet(), new EncapContentInfo("1.2.840.113549.1.7.1", null), hashSet, null, new HashSet());
        ContentInfo contentInfo = new ContentInfo("1.2.840.113549.1.7.2", signedData);
        return contentInfo;
    }

    public void processPKCS10(byte[] byArray) throws ToolException {
        try {
            PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)CertRequestFactory.getRequest("PKCS10", byArray);
            pKCS10CertificationRequest.verifySignature();
            this.setSubjectDN(pKCS10CertificationRequest.getSubjectName());
            KeyFactory keyFactory = KeyFactory.getInstance(pKCS10CertificationRequest.getKeyAlgName());
            this.setSubjectPubKey(keyFactory.generatePublic(new X509EncodedKeySpec(pKCS10CertificationRequest.getSubjectPublicKeyInfo().encode())));
            Set set = pKCS10CertificationRequest.getCertificationRequestInfo().getSignedAttributes();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                if (!attribute.getType().equals("1.2.840.113549.1.9.1")) continue;
                this.setEmail(((IA5String)attribute.getValues().elementAt(0)).getName());
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void resetSubjectInfo() {
        this.email = null;
        this.subjectName = null;
        this.subjectPubKey = null;
        this.extns = null;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public void setIssuerDN(String string) {
        try {
            this.issuer = new X500Name(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setSignatureAlgorithm(String string) {
        this.sigAlgName = string;
    }

    public void setSubjectDN(String string) {
        this.subjectName = string;
    }

    public void setSubjectPubKey(PublicKey publicKey) {
        this.subjectPubKey = publicKey;
    }

    public void setValidityPeriod(int n) {
        this.validityPeriod = n;
    }

    protected class ToolException
    extends Exception {
        protected ToolException(String string) {
            super(string);
        }
    }
}

