/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.pkcs8.PKCS8EncryptedPrivateKey;
import com.dstc.security.pki.CertGenerator;
import com.dstc.security.pki.ConsoleKeyTool;
import com.dstc.security.pki.KeyGenerator;
import com.dstc.security.util.Config;
import com.dstc.security.util.ConfigException;
import com.dstc.security.x509.RevokedCertificate;
import com.dstc.security.x509.extns.BasicConstraints;
import com.dstc.security.x509.extns.NetscapeCertType;
import com.dstc.security.x509.extns.SubjectKeyIdentifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public class ConsoleCATool
extends CertGenerator {
    private static final String CA_CONF = "jcsi.ca.conf";
    private static final String CA_PROPERTIES = "ca.properties";
    private String keyAlgName;
    private String keyDir;
    private CertificateFactory certFact;
    private Properties props = Config.getProperties("jcsi.ca.conf", "ca.properties");

    public ConsoleCATool() throws ConfigException, CertGenerator.ToolException {
        this.keyDir = (String)((Hashtable)this.props).get("jcsi.ca.key.dir");
        String string = (String)((Hashtable)this.props).get("jcsi.ca.issuerDN");
        if (string == null) {
            ConsoleCATool consoleCATool = this;
            consoleCATool.getClass();
            throw consoleCATool.new CertGenerator.ToolException("Issuer's Distinguished Name unspecified");
        }
        this.setIssuerDN(string);
        this.keyAlgName = (String)((Hashtable)this.props).get("jcsi.ca.keyAlg");
        if (this.keyAlgName == null) {
            ConsoleCATool consoleCATool = this;
            consoleCATool.getClass();
            throw consoleCATool.new CertGenerator.ToolException("Issuer's Key algorithm unspecified");
        }
        String string2 = (String)((Hashtable)this.props).get("jcsi.ca.sigAlg");
        if (string2 == null) {
            ConsoleCATool consoleCATool = this;
            consoleCATool.getClass();
            throw consoleCATool.new CertGenerator.ToolException("Issuer's signature algorithm unspecified");
        }
        this.setSignatureAlgorithm(string2);
        try {
            this.certFact = CertificateFactory.getInstance("X509");
        }
        catch (Exception exception) {
            ConsoleCATool consoleCATool = this;
            consoleCATool.getClass();
            throw consoleCATool.new CertGenerator.ToolException(exception.getMessage());
        }
    }

    public void generateKeysAndSelfSignedCert(SecureRandom secureRandom) {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyAlgName);
            int n = Integer.parseInt((String)((Hashtable)this.props).get("jcsi.ca.keyLength"));
            keyPairGenerator.initialize(n, secureRandom);
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            System.out.print("\nFile to save private key? ");
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            FileOutputStream fileOutputStream = new FileOutputStream(bufferedReader.readLine());
            PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = new PKCS8EncryptedPrivateKey(privateKey);
            System.out.print("\nEnter password to lock private key? ");
            pKCS8EncryptedPrivateKey.encrypt(bufferedReader.readLine());
            fileOutputStream.write(pKCS8EncryptedPrivateKey.getEncoded());
            String string = (String)((Hashtable)this.props).get("jcsi.ca.issuerDN");
            String string2 = (String)((Hashtable)this.props).get("jcsi.ca.email");
            int n2 = Integer.parseInt((String)((Hashtable)this.props).get("jcsi.ca.validityPeriod"));
            this.init(privateKey, null);
            this.setSubjectDN(string);
            this.setEmail(string2);
            this.setSubjectPubKey(keyPair.getPublic());
            this.setValidityPeriod(n2);
            this.addExtension(new BasicConstraints(true, true, 5));
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(keyPair.getPublic().getEncoded());
            this.addExtension(new SubjectKeyIdentifier(true, messageDigest.digest()));
            this.addExtension(new NetscapeCertType(true, 6));
            BigInteger bigInteger = BigInteger.valueOf(Calendar.getInstance().getTime().getTime());
            X509Certificate x509Certificate = this.generateCertificate(2, bigInteger);
            System.out.print("\nFile to save cert? ");
            fileOutputStream = new FileOutputStream(bufferedReader.readLine());
            fileOutputStream.write(x509Certificate.getEncoded());
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void init(byte[] byArray, X509Certificate x509Certificate) throws CertGenerator.ToolException {
        try {
            PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = new PKCS8EncryptedPrivateKey(byArray);
            System.out.print("\nEnter password to unlock signer private key: ");
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            pKCS8EncryptedPrivateKey.decrypt(bufferedReader.readLine());
            this.init(pKCS8EncryptedPrivateKey.getPrivateKey(), x509Certificate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ConsoleCATool consoleCATool = this;
            consoleCATool.getClass();
            throw consoleCATool.new CertGenerator.ToolException(exception.getMessage());
        }
    }

    public void loadPrivateKeyAndCert() throws CertGenerator.ToolException {
        try {
            String string = (String)((Hashtable)this.props).get("jcsi.ca.privKey");
            if (string == null) {
                ConsoleCATool consoleCATool = this;
                consoleCATool.getClass();
                throw consoleCATool.new CertGenerator.ToolException("Location of encrypted PrivateKey unspecified");
            }
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(this.keyDir) + File.separator + string);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            string = (String)((Hashtable)this.props).get("jcsi.ca.cert");
            if (string == null) {
                ConsoleCATool consoleCATool = this;
                consoleCATool.getClass();
                throw consoleCATool.new CertGenerator.ToolException("Location of CA certificate unspecified");
            }
            fileInputStream = new FileInputStream(String.valueOf(this.keyDir) + File.separator + string);
            X509Certificate x509Certificate = (X509Certificate)this.certFact.generateCertificate(fileInputStream);
            this.init(byArray, x509Certificate);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ConsoleCATool consoleCATool = this;
            consoleCATool.getClass();
            throw consoleCATool.new CertGenerator.ToolException(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        SecureRandom secureRandom = null;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n = 100;
        try {
            ConsoleCATool consoleCATool = new ConsoleCATool();
            while (true) {
                Sequence sequence;
                Object object;
                FileInputStream fileInputStream;
                Object object2;
                FileOutputStream fileOutputStream;
                Object object3;
                System.out.print("\nGenerate (S)elf-signed cert, (U)ser cert, (C)RL or (Q)uit? ");
                String string = bufferedReader.readLine();
                if (string.equalsIgnoreCase("Q")) break;
                if (string.equalsIgnoreCase("S")) {
                    if (secureRandom == null) {
                        System.out.println("Seeding random number generator. Please wait...");
                        secureRandom = new SecureRandom();
                        secureRandom.nextInt();
                    }
                    consoleCATool.generateKeysAndSelfSignedCert(secureRandom);
                    continue;
                }
                if (string.equalsIgnoreCase("U")) {
                    if (!consoleCATool.isInitialized()) {
                        consoleCATool.loadPrivateKeyAndCert();
                    }
                    System.out.print("\n(G)enerate KeyPair, (I)mport public key from PKCS#10 request or (Q)uit? ");
                    string = bufferedReader.readLine();
                    if (!string.equalsIgnoreCase("Q")) {
                        if (string.equalsIgnoreCase("G")) {
                            if (secureRandom == null) {
                                System.out.println("Seeding random number generator. Please wait...");
                                secureRandom = new SecureRandom();
                                secureRandom.nextInt();
                            }
                            object3 = new ConsoleKeyTool(secureRandom);
                            ((ConsoleKeyTool)object3).setKeyAlgorithm();
                            ((ConsoleKeyTool)object3).setKeyLength();
                            ((ConsoleKeyTool)object3).setAlgParameters();
                            ((KeyGenerator)object3).generateKeyPair();
                            System.out.print("\nFile to save private key? ");
                            fileOutputStream = new FileOutputStream(bufferedReader.readLine());
                            object2 = new PKCS8EncryptedPrivateKey(((KeyGenerator)object3).getPrivate());
                            System.out.print("\nEnter password to lock private key? ");
                            ((PKCS8EncryptedPrivateKey)object2).encrypt(bufferedReader.readLine());
                            fileOutputStream.write(((PKCS8EncryptedPrivateKey)object2).getEncoded());
                            fileOutputStream.close();
                            consoleCATool.setSubjectPubKey(((KeyGenerator)object3).getPublic());
                            ((ConsoleKeyTool)object3).setDistinguishedName();
                            ((ConsoleKeyTool)object3).setEmailAddress();
                            consoleCATool.setSubjectDN(((KeyGenerator)object3).getDN());
                            consoleCATool.setEmail(((KeyGenerator)object3).getEmail());
                        } else if (string.equalsIgnoreCase("I")) {
                            System.out.print("\nFile to import PKCS#10 request? ");
                            fileInputStream = new FileInputStream(bufferedReader.readLine());
                            object3 = new byte[fileInputStream.available()];
                            fileInputStream.read((byte[])object3);
                            consoleCATool.processPKCS10((byte[])object3);
                        }
                        consoleCATool.setNetscapeExtension();
                        object3 = BigInteger.valueOf(Calendar.getInstance().getTime().getTime());
                        object2 = consoleCATool.generateCertificate(2, (BigInteger)object3);
                        System.out.print("\nSave as (C)ert or (P)KCS#7 cert-chain? ");
                        object = bufferedReader.readLine();
                        if (((String)object).equalsIgnoreCase("C")) {
                            System.out.print("\nFile to save cert? ");
                            fileOutputStream = new FileOutputStream(bufferedReader.readLine());
                            fileOutputStream.write(((Certificate)object2).getEncoded());
                            continue;
                        }
                        sequence = consoleCATool.makeCertChain((X509Certificate)object2);
                        System.out.print("\nFile to save cert chain? ");
                        fileOutputStream = new FileOutputStream(bufferedReader.readLine());
                        fileOutputStream.write(sequence.encode());
                        continue;
                    }
                    break;
                }
                if (!string.equalsIgnoreCase("C")) continue;
                if (!consoleCATool.isInitialized()) {
                    consoleCATool.loadPrivateKeyAndCert();
                }
                System.out.print("\nCRL to add to? ");
                fileInputStream = new FileInputStream(bufferedReader.readLine());
                object3 = CertificateFactory.getInstance("X509");
                object2 = (X509CRL)((CertificateFactory)object3).generateCRL(fileInputStream);
                System.out.println(((CRL)object2).toString());
                System.out.print("\nCertificate to revoke? ");
                fileInputStream = new FileInputStream(bufferedReader.readLine());
                object = (X509Certificate)((CertificateFactory)object3).generateCertificate(fileInputStream);
                sequence = new RevokedCertificate(((X509Certificate)object).getSerialNumber(), new UTCTime(0), null);
                HashSet<Sequence> hashSet = new HashSet<Sequence>();
                hashSet.add(sequence);
                X509CRL x509CRL = consoleCATool.generateCRL(new UTCTime(0), new UTCTime(10), hashSet);
                System.out.print("\nFile to save crl? ");
                fileOutputStream = new FileOutputStream(bufferedReader.readLine());
                fileOutputStream.write(x509CRL.getEncoded());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setNetscapeExtension() throws IOException {
        byte by = 0;
        while (true) {
            System.out.print("\nNetscape Certificate Extension for\n  1) S/MIME Client\n  2) SSL Client\n  3) SSL Server\n or (Q)uit? ");
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            if (string.equalsIgnoreCase("Q")) break;
            if (string.equalsIgnoreCase("1")) {
                by = (byte)(by | 0x20);
                continue;
            }
            if (string.equalsIgnoreCase("2")) {
                by = (byte)(by | 0xFFFFFF80);
                continue;
            }
            if (!string.equalsIgnoreCase("3")) continue;
            by = (byte)(by | 0x40);
        }
        if (by != 0) {
            this.addExtension(new NetscapeCertType(true, by));
        }
    }
}

