/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.pkcs8.PKCS8EncryptedPrivateKey;
import com.dstc.security.pki.KeyGenerator;
import com.dstc.security.pki.pkcs10.CertificationRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class ConsoleKeyTool
extends KeyGenerator {
    private BufferedReader inr;
    private String resp;

    public ConsoleKeyTool(SecureRandom secureRandom) {
        super(secureRandom);
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        this.inr = new BufferedReader(inputStreamReader);
    }

    public static void main(String[] stringArray) {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            System.out.println("Seeding random number generator. Please wait...");
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextInt();
            ConsoleKeyTool consoleKeyTool = new ConsoleKeyTool(secureRandom);
            while (true) {
                System.out.print("\nGenerate (K)eyPair or (Q)uit? ");
                String string = bufferedReader.readLine();
                if (!string.equalsIgnoreCase("Q")) {
                    if (!string.equalsIgnoreCase("K")) continue;
                    consoleKeyTool.setKeyAlgorithm();
                    if (consoleKeyTool.getKeyAlgorithm().equals("RSA")) {
                        consoleKeyTool.setKeyLength();
                    } else {
                        consoleKeyTool.setAlgParameters();
                    }
                    consoleKeyTool.generateKeyPair();
                    PrivateKey privateKey = consoleKeyTool.getPrivate();
                    PublicKey publicKey = consoleKeyTool.getPublic();
                    System.out.print("\nFile to save private key? ");
                    FileOutputStream fileOutputStream = new FileOutputStream(bufferedReader.readLine());
                    PKCS8EncryptedPrivateKey pKCS8EncryptedPrivateKey = new PKCS8EncryptedPrivateKey(privateKey);
                    System.out.print("\nEnter password to lock private key? ");
                    pKCS8EncryptedPrivateKey.encrypt(bufferedReader.readLine());
                    fileOutputStream.write(pKCS8EncryptedPrivateKey.getEncoded());
                    fileOutputStream.close();
                    System.out.print("\n(G)enerate PKCS#10 request or (Q)uit? ");
                    string = bufferedReader.readLine();
                    if (!string.equalsIgnoreCase("Q")) {
                        if (!string.equalsIgnoreCase("G")) continue;
                        consoleKeyTool.setDistinguishedName();
                        consoleKeyTool.setEmailAddress();
                        CertificationRequest certificationRequest = consoleKeyTool.constructRequest();
                        System.out.print("\nPKCS#10 Request to (F)ile or (S)end to CA: ");
                        string = bufferedReader.readLine();
                        if (string.equalsIgnoreCase("F")) {
                            System.out.print("\nFile to save PKCS#10 request? ");
                            fileOutputStream = new FileOutputStream(bufferedReader.readLine());
                            fileOutputStream.write(certificationRequest.encode());
                            fileOutputStream.close();
                            continue;
                        }
                        if (!string.equalsIgnoreCase("S")) continue;
                        byte[] byArray = consoleKeyTool.sendRequest(certificationRequest.encode());
                        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                        System.out.println("\nThe returned certificate's details: ");
                        System.out.println("######################################");
                        System.out.println(x509Certificate.toString());
                        System.out.println("######################################");
                        System.out.print("\nFile to save certificate? ");
                        fileOutputStream = new FileOutputStream(bufferedReader.readLine());
                        fileOutputStream.write(x509Certificate.getEncoded());
                        fileOutputStream.close();
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected byte[] sendRequest(byte[] byArray) throws KeyGenerator.ToolException {
        try {
            byte[] byArray2 = null;
            System.out.print("\nEnter URL for online CA: ");
            URL uRL = new URL(this.inr.readLine());
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            System.out.println("Request sent. Waiting for reply...");
            if (httpURLConnection.getResponseCode() == 200) {
                InputStream inputStream = httpURLConnection.getInputStream();
                while (inputStream.available() == 0) {
                }
                byArray2 = new byte[inputStream.available()];
                int n = inputStream.read(byArray2);
                inputStream.close();
            }
            return byArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ConsoleKeyTool consoleKeyTool = this;
            consoleKeyTool.getClass();
            throw new KeyGenerator.ToolException(consoleKeyTool, exception.getMessage());
        }
    }

    protected void setAlgParameters() throws KeyGenerator.ToolException {
        block4: {
            if (this.getKeyAlgorithm().equals("RSA")) {
                return;
            }
            try {
                do {
                    System.out.print("\n(G)enerate or (P)rovide Algorithm parameters? ");
                    this.resp = this.inr.readLine();
                    if (!this.resp.equalsIgnoreCase("G")) continue;
                    this.setKeyLength();
                    System.out.println("Generating parameters. Please wait...");
                    this.generateAlgParameters();
                    break block4;
                } while (!this.resp.equalsIgnoreCase("P"));
                System.out.print("\nCertificate containing required parameters? ");
                FileInputStream fileInputStream = new FileInputStream(this.inr.readLine());
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                this.setAlgParameters(x509Certificate);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ConsoleKeyTool consoleKeyTool = this;
                consoleKeyTool.getClass();
                throw new KeyGenerator.ToolException(consoleKeyTool, exception.getMessage());
            }
        }
    }

    protected void setDistinguishedName() throws IOException {
        System.err.println("Enter Subject Distinguished Name: ");
        StringBuffer stringBuffer = new StringBuffer();
        System.err.print("Common Name: ");
        stringBuffer.append("2.5.4.3=");
        stringBuffer.append(this.inr.readLine());
        System.err.print("Organizational Unit: ");
        stringBuffer.append(", 2.5.4.11=");
        stringBuffer.append(this.inr.readLine());
        System.err.print("Organization: ");
        stringBuffer.append(", 2.5.4.10=");
        stringBuffer.append(this.inr.readLine());
        System.err.print("Country: ");
        stringBuffer.append(", 2.5.4.6=");
        stringBuffer.append(this.inr.readLine());
        this.setDistinguishedName(stringBuffer.toString());
    }

    protected void setEmailAddress() throws IOException {
        System.err.print("Email: ");
        this.setEmailAddress(this.inr.readLine());
    }

    protected void setKeyAlgorithm() throws IOException {
        System.out.print("\nKey Algorithm: (R)SA, (D)SA or Diffie-(H)ellman? ");
        this.resp = this.inr.readLine();
        if (this.resp.equalsIgnoreCase("R")) {
            this.setKeyAlgorithm("RSA");
        } else if (this.resp.equalsIgnoreCase("D")) {
            this.setKeyAlgorithm("DSA");
        } else if (this.resp.equalsIgnoreCase("H")) {
            this.setKeyAlgorithm("DH");
        }
    }

    protected void setKeyLength() throws IOException {
        System.out.print("\nKey length: (1) 1024, (2) 768 or (3) 512? ");
        this.resp = this.inr.readLine();
        if (this.resp.equalsIgnoreCase("1")) {
            this.setKeyLength(1024);
        } else if (this.resp.equalsIgnoreCase("2")) {
            this.setKeyLength(768);
        }
        if (this.resp.equalsIgnoreCase("3")) {
            this.setKeyLength(512);
        }
    }
}

