/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.pki.pkcs10.CertificationRequest;
import com.dstc.security.pki.pkcs10.CertificationRequestInfo;
import com.dstc.security.x509.Attribute;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import com.dstc.security.x509.X500Name;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashSet;

public class KeyGenerator {
    private String keyAlg;
    private String sigAlg;
    private KeyPair kp;
    private SecureRandom ran;
    private String dn;
    private String email;
    private AlgorithmParameterSpec paramSpec;
    private int strength = 0;

    public KeyGenerator(SecureRandom secureRandom) {
        this.ran = secureRandom;
    }

    public CertificationRequest constructRequest() throws Asn1Exception, ToolException, IOException {
        if (this.dn == null) {
            throw new ToolException("Distinguished Name not yet set");
        }
        if (this.email == null) {
            throw new ToolException("Email address not yet set");
        }
        if (this.kp == null) {
            throw new ToolException("Key pair not yet generated");
        }
        HashSet<Attribute> hashSet = new HashSet<Attribute>();
        hashSet.add(new Attribute("1.2.840.113549.1.9.1", new IA5String(this.email)));
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(this.kp.getPublic().getEncoded());
        CertificationRequestInfo certificationRequestInfo = new CertificationRequestInfo(new X500Name(this.dn), subjectPublicKeyInfo, hashSet);
        CertificationRequest certificationRequest = new CertificationRequest(certificationRequestInfo, this.sigAlg, this.kp.getPrivate());
        return certificationRequest;
    }

    public void generateAlgParameters() throws ToolException {
        if (this.keyAlg == null) {
            throw new ToolException("Key algorithm not yet set");
        }
        if (!this.keyAlg.equals("DSA") && !this.keyAlg.equals("DH")) {
            throw new ToolException("No parameters for selected algorithm");
        }
        if (this.strength == 0) {
            throw new ToolException("Key length not yet set");
        }
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(this.keyAlg);
            algorithmParameterGenerator.init(this.strength, this.ran);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            if (this.keyAlg.equals("DSA")) {
                this.paramSpec = algorithmParameters.getParameterSpec(Class.forName("java.security.spec.DSAParameterSpec"));
            } else if (this.keyAlg.equals("DH")) {
                this.paramSpec = algorithmParameters.getParameterSpec(Class.forName("javax.crypto.spec.DHParameterSpec"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void generateKeyPair() throws ToolException {
        if (this.keyAlg == null) {
            throw new ToolException("Key algorithm not yet set");
        }
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyAlg);
            if (this.keyAlg.equalsIgnoreCase("DH") || this.keyAlg.equalsIgnoreCase("DSA")) {
                if (this.paramSpec == null) {
                    throw new ToolException("Algorithm parameters unspecified");
                }
                keyPairGenerator.initialize(this.paramSpec);
            } else {
                if (this.strength == 0) {
                    throw new ToolException("Key length not yet set");
                }
                keyPairGenerator.initialize(this.strength, this.ran);
            }
            this.kp = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public String getDN() {
        return this.dn;
    }

    public String getEmail() {
        return this.email;
    }

    public String getKeyAlgorithm() {
        return this.keyAlg;
    }

    public PrivateKey getPrivate() {
        return this.kp.getPrivate();
    }

    public PublicKey getPublic() {
        return this.kp.getPublic();
    }

    public void setAlgParameters(X509Certificate x509Certificate) throws ToolException {
        if (this.keyAlg == null) {
            throw new ToolException("Key algorithm not yet set");
        }
        if (!this.keyAlg.equals("DSA") && !this.keyAlg.equals("DH")) {
            throw new ToolException("No parameters for selected algorithm");
        }
        try {
            AlgorithmParameters algorithmParameters = new SubjectPublicKeyInfo(x509Certificate.getPublicKey().getEncoded()).getAlgorithmId().getParams();
            if (this.keyAlg.equals("DSA")) {
                this.paramSpec = algorithmParameters.getParameterSpec(Class.forName("java.security.spec.DSAParameterSpec"));
            } else if (this.keyAlg.equals("DH")) {
                this.paramSpec = algorithmParameters.getParameterSpec(Class.forName("javax.crypto.spec.DHParameterSpec"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ToolException(exception.getMessage());
        }
    }

    public void setDistinguishedName(String string) {
        this.dn = string;
    }

    public void setEmailAddress(String string) {
        this.email = string;
    }

    public void setKeyAlgorithm(String string) {
        this.keyAlg = string;
        if (string.equals("RSA")) {
            this.sigAlg = "1.2.840.113549.1.1.4";
        } else if (string.equals("DSA")) {
            this.sigAlg = "1.2.840.10040.4.3";
        } else if (string.equals("DH")) {
            this.sigAlg = "1.0.1.0.1.0";
        }
    }

    public void setKeyLength(int n) {
        this.strength = n;
    }

    protected class ToolException
    extends Exception {
        protected ToolException(String string) {
            super(string);
        }
    }
}

