/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class Repository {
    protected String BASE;
    protected String USER_CERT_ATTR_TYPE = "userCertificate;binary";
    protected String CA_CERT_ATTR_TYPE = "caCertificate;binary";
    protected DirContext ctx;
    protected CertificateFactory fact;

    public Repository(Properties properties) {
        try {
            this.fact = CertificateFactory.getInstance("X509");
            String string = (String)((Hashtable)properties).get("jcsi.rep.userCertAttrType");
            if (string != null) {
                this.setUserCertificateAttributeType(string);
            }
            if ((string = (String)((Hashtable)properties).get("jcsi.rep.caCertAttrType")) != null) {
                this.setCACertificateAttributeType(string);
            }
            if ((string = (String)((Hashtable)properties).get("jcsi.rep.searchBase")) != null) {
                this.setSearchBase(string);
            }
            string = (String)((Hashtable)properties).get("jcsi.rep.url");
            ((Hashtable)properties).put("java.naming.provider.url", string);
            ((Hashtable)properties).put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            ((Hashtable)properties).put("java.naming.ldap.version", "2");
            this.ctx = new InitialDirContext(properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void authenticate(String string, String string2) {
    }

    public X509Certificate getCACertificate(String string) throws NamingException {
        return this.getCert(this.CA_CERT_ATTR_TYPE, string);
    }

    private X509Certificate getCert(String string, String string2) throws NamingException {
        try {
            Attributes attributes = this.ctx.getAttributes(string2);
            if (attributes == null) {
                throw new Exception(String.valueOf(string2) + " has no attributes");
            }
            byte[] byArray = (byte[])attributes.get(string).get();
            if (byArray == null) {
                throw new Exception(String.valueOf(string2) + "has no associated certificate");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            return (X509Certificate)this.fact.generateCertificate(byteArrayInputStream);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public X509Certificate getUserCertificate(String string) throws NamingException {
        return this.getCert(this.USER_CERT_ATTR_TYPE, string);
    }

    private void publish(String string, String string2, X509Certificate x509Certificate, Attributes attributes) throws NamingException {
        try {
            BasicAttribute basicAttribute = new BasicAttribute(string, x509Certificate.getEncoded());
            Attributes attributes2 = attributes != null ? (Attributes)attributes.clone() : new BasicAttributes(true);
            attributes2.put(basicAttribute);
            this.ctx.rebind(string2, null, attributes2);
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void publishCACertificate(String string, X509Certificate x509Certificate, Attributes attributes) throws NamingException {
        this.publish(this.CA_CERT_ATTR_TYPE, string, x509Certificate, attributes);
    }

    public void publishUserCertificate(String string, X509Certificate x509Certificate, Attributes attributes) throws NamingException {
        this.publish(this.USER_CERT_ATTR_TYPE, string, x509Certificate, attributes);
    }

    public void setCACertificateAttributeType(String string) {
        this.CA_CERT_ATTR_TYPE = string;
    }

    public void setSearchBase(String string) {
        this.BASE = string;
    }

    public void setUserCertificateAttributeType(String string) {
        this.USER_CERT_ATTR_TYPE = string;
    }
}

