/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.pki.Repository;
import com.dstc.security.util.Config;
import com.dstc.security.x509.ExtensionFactory;
import com.dstc.security.x509.RDN;
import com.dstc.security.x509.X500Name;
import com.dstc.security.x509.extns.SubjectAltName;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class RepositoryTool
extends Repository {
    public static final String CA_CONF = "jcsi.ca.conf";
    public static final String CA_PROPERTIES = "ca.properties";

    public RepositoryTool(Properties properties) {
        super(properties);
    }

    public Attributes getOtherAttributes(X509Certificate x509Certificate) {
        try {
            SubjectAltName subjectAltName;
            BasicAttributes basicAttributes = new BasicAttributes(true);
            Hashtable hashtable = RepositoryTool.getRDNs(new X500Name(x509Certificate.getSubjectDN().getName()));
            String string = (String)hashtable.get("CN");
            if (string != null) {
                basicAttributes.put("cn", string);
            }
            if ((string = (String)hashtable.get("O")) != null) {
                basicAttributes.put("o", string);
            }
            if ((string = (String)hashtable.get("OU")) != null) {
                basicAttributes.put("ou", string);
            }
            if ((subjectAltName = (SubjectAltName)ExtensionFactory.getExtension("2.5.29.17", x509Certificate)) != null) {
                string = subjectAltName.getName();
                if (string != null) {
                    basicAttributes.put("mail", string);
                }
            } else {
                string = (String)hashtable.get("EmailAddress");
                if (string != null) {
                    basicAttributes.put("mail", string);
                }
            }
            return basicAttributes;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Hashtable getRDNs(X500Name x500Name) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector vector = x500Name.getRDNs();
        int n = 0;
        while (n < vector.size()) {
            String string = ((RDN)vector.elementAt(n)).getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=", false);
            hashtable.put(stringTokenizer.nextToken().trim(), stringTokenizer.nextToken().trim());
            ++n;
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        Object object;
        RepositoryTool repositoryTool = null;
        BufferedReader bufferedReader = null;
        try {
            object = Config.getProperties(CA_CONF, CA_PROPERTIES);
            repositoryTool = new RepositoryTool((Properties)object);
            repositoryTool.search();
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            bufferedReader = new BufferedReader(inputStreamReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        block5: while (true) {
            try {
                while (true) {
                    Object object2;
                    Object object3;
                    System.out.print("\n(P)ublish cert, (R)etrieve cert, or (Q)uit? ");
                    object = bufferedReader.readLine();
                    if (((String)object).equalsIgnoreCase("Q")) break block5;
                    if (((String)object).equalsIgnoreCase("R")) {
                        System.out.print("\nDistinguished Name cert is published under? ");
                        X509Certificate x509Certificate = repositoryTool.getUserCertificate(bufferedReader.readLine());
                        System.out.println("\nThe following cert was retrieved:\n");
                        System.out.println(x509Certificate.toString());
                        System.out.print("\nFile to save cert or (Q)uit? ");
                        object3 = bufferedReader.readLine();
                        if (((String)object3).equalsIgnoreCase("Q")) continue;
                        object2 = new FileOutputStream((String)object3);
                        ((FileOutputStream)object2).write(x509Certificate.getEncoded());
                        ((FileOutputStream)object2).close();
                        continue;
                    }
                    if (!((String)object).equalsIgnoreCase("P")) continue;
                    boolean bl = false;
                    System.out.print("\nPublish a (C)A cert or a (U)ser cert? ");
                    if (bufferedReader.readLine().equalsIgnoreCase("C")) {
                        bl = true;
                    }
                    System.out.print("\nCertificate file name? ");
                    object3 = new FileInputStream(bufferedReader.readLine());
                    object2 = new byte[((FileInputStream)object3).available()];
                    ((FileInputStream)object3).read((byte[])object2);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                    System.out.println("\nAbout to publish the following cert:\n");
                    System.out.println("Issuer: " + x509Certificate.getIssuerDN().getName());
                    System.out.println("Subject: " + x509Certificate.getSubjectDN().getName());
                    System.out.print("\nDistinguished Name to publish cert under? ");
                    Attributes attributes = repositoryTool.getOtherAttributes(x509Certificate);
                    if (bl) {
                        attributes.put(new BasicAttribute("objectclass", "certificationAuthority"));
                        repositoryTool.publishCACertificate(bufferedReader.readLine(), x509Certificate, attributes);
                        continue;
                    }
                    attributes.put(new BasicAttribute("objectclass", "person"));
                    repositoryTool.publishUserCertificate(bufferedReader.readLine(), x509Certificate, attributes);
                }
            }
            catch (NamingException namingException) {
                System.out.println(namingException.toString());
                continue;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void search() throws NamingException {
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search(this.BASE, "(objectclass=*)", searchControls);
            while (namingEnumeration != null && namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                searchResult.setRelative(false);
                System.out.println("name: " + searchResult.getName());
            }
        }
        catch (NamingException namingException) {
            throw namingException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

