/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki.netscape;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;

public class SignedPubKeyAndChallenge
extends Sequence {
    private PubKeyAndChallenge pkc;
    private AlgorithmId algo;
    private byte[] sig;

    public SignedPubKeyAndChallenge(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.pkc = new PubKeyAndChallenge(((Asn1)this.components.elementAt(0)).encode());
        this.algo = new AlgorithmId(((Asn1)this.components.elementAt(1)).encode());
        this.sig = ((BitString)this.components.elementAt(2)).getBytes();
    }

    public String getKeyAlgName() {
        return OID.getAlgName(this.pkc.spki.getAlgorithmId().getOid());
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.algo.getOid());
    }

    public byte[] getSignature() {
        return this.sig;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.pkc.spki;
    }

    public boolean verifySignature() {
        try {
            Signature signature = Signature.getInstance(this.getSigAlgName());
            KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyAlgName());
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(this.pkc.spki.encode()));
            signature.initVerify(publicKey);
            signature.update(this.pkc.encode());
            return signature.verify(this.sig);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected class PubKeyAndChallenge
    extends Sequence {
        private SubjectPublicKeyInfo spki;
        private String challenge;

        protected PubKeyAndChallenge(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.spki = new SubjectPublicKeyInfo(((Asn1)this.components.elementAt(0)).encode());
            this.challenge = ((IA5String)this.components.elementAt(1)).getName();
        }
    }
}

