/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki.pkcs10;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.pki.pkcs10.CertificationRequestInfo;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.AlgorithmId;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;

public class CertificationRequest
extends Sequence {
    private CertificationRequestInfo crInfo;
    private String sigAlgName;
    private byte[] signature;

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, String string, PrivateKey privateKey) {
        this.crInfo = certificationRequestInfo;
        this.addComponent(certificationRequestInfo);
        this.sigAlgName = string;
        this.addComponent(new AlgorithmId(string));
        try {
            Signature signature = Signature.getInstance(OID.getAlgName(string));
            signature.initSign(privateKey);
            signature.update(certificationRequestInfo.encode());
            this.signature = signature.sign();
            this.addComponent(new BitString(this.signature));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public CertificationRequest(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.crInfo = new CertificationRequestInfo(((Asn1)this.components.elementAt(0)).encode());
        AlgorithmId algorithmId = new AlgorithmId(((Asn1)this.components.elementAt(1)).encode());
        this.sigAlgName = algorithmId.getOid();
        this.signature = ((BitString)this.components.elementAt(2)).getBytes();
    }

    public CertificationRequestInfo getCertificationRequestInfo() {
        return this.crInfo;
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.sigAlgName);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean verifySignature() {
        try {
            Signature signature = Signature.getInstance(this.getSigAlgName());
            KeyFactory keyFactory = KeyFactory.getInstance(this.crInfo.getKeyAlgName());
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(this.crInfo.getSubjectPublicKeyInfo().encode()));
            signature.initVerify(publicKey);
            signature.update(this.crInfo.encode());
            return signature.verify(this.signature);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

