/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki.pkcs10;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Constructed;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.SetOf;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.Attribute;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import com.dstc.security.x509.X500Name;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class CertificationRequestInfo
extends Sequence {
    private int version;
    private X500Name subject;
    private SubjectPublicKeyInfo spki;
    private Set atts;

    public CertificationRequestInfo(X500Name x500Name, SubjectPublicKeyInfo subjectPublicKeyInfo, Set set) {
        this.version = 0;
        this.addComponent(new Integer(0));
        this.subject = x500Name;
        this.addComponent(x500Name);
        this.spki = subjectPublicKeyInfo;
        this.addComponent(subjectPublicKeyInfo);
        this.atts = set;
        if (set != null) {
            SetOf setOf = new SetOf();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                setOf.addComponent((Attribute)iterator.next());
            }
            setOf.setTagClass((byte)-128);
            setOf.setTagNumber(0);
            this.addComponent(setOf);
        }
    }

    public CertificationRequestInfo(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        this.version = ((Integer)this.components.elementAt(n++)).getInt();
        this.subject = new X500Name(((Asn1)this.components.elementAt(n++)).encode());
        this.spki = new SubjectPublicKeyInfo(((Asn1)this.components.elementAt(n++)).encode());
        if (this.components.size() == n) {
            return;
        }
        this.atts = new HashSet();
        Vector vector = ((Constructed)this.components.elementAt(n)).getComponents();
        int n2 = 0;
        while (n2 < vector.size()) {
            this.atts.add(new Attribute(((Asn1)vector.elementAt(n2)).encode()));
            ++n2;
        }
    }

    public String getKeyAlgName() {
        return OID.getAlgName(this.getSubjectPublicKeyInfo().getAlgorithmId().getOid());
    }

    public Set getSignedAttributes() {
        return this.atts;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.spki;
    }
}

