/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.BlowfishSecretKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public final class BlowfishSecretKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof SecretKeySpec) {
            if (!((SecretKeySpec)keySpec).getAlgorithm().equals("Blowfish")) {
                throw new InvalidKeySpecException("Not a Blowfish key spec");
            }
            return new BlowfishSecretKey(((SecretKeySpec)keySpec).getEncoded());
        }
        throw new InvalidKeySpecException("Not a Blowfish key spec");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("No Blowfish-specific keyspec supported");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey instanceof SecretKeySpec) {
            return new BlowfishSecretKey(secretKey.getEncoded());
        }
        if (secretKey instanceof BlowfishSecretKey) {
            return new SecretKeySpec(secretKey.getEncoded(), "Blowfish");
        }
        throw new InvalidKeyException("Cannot translate this key");
    }
}

