/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DESSecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class DESKeyGenerator
extends KeyGeneratorSpi {
    private int keyLength = 64;
    private SecureRandom random;

    protected SecretKey engineGenerateKey() {
        byte[] byArray = new byte[this.keyLength / 8];
        this.random.nextBytes(byArray);
        DESKeyGenerator.forceOddParity(byArray);
        return new DESSecretKey(byArray);
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.keyLength = n;
        this.random = secureRandom;
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Params not supported");
    }

    private static void forceOddParity(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            int n3 = 7;
            while (n3 >= 0) {
                n2 += byArray[n] >>> n3 & 1;
                --n3;
            }
            if (n2 % 2 == 0) {
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] ^ 1);
            }
            ++n;
        }
    }
}

