/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DESSecretKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class DESSecretKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DESKeySpec) {
            return new DESSecretKey(((DESKeySpec)keySpec).getKey());
        }
        if (keySpec instanceof SecretKeySpec) {
            if (!((SecretKeySpec)keySpec).getAlgorithm().equals("DES")) {
                throw new InvalidKeySpecException("Not a DES key spec");
            }
            return new DESSecretKey(((SecretKeySpec)keySpec).getEncoded());
        }
        throw new InvalidKeySpecException("Not a DES key spec");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (!secretKey.getAlgorithm().equals("DES")) {
            throw new InvalidKeySpecException("Not a DES key");
        }
        if (!secretKey.getFormat().equals("RAW")) {
            throw new InvalidKeySpecException("Key in unrecognized format");
        }
        if (!clazz.getName().equals("javax.crypto.spec.DESKeySpec")) {
            throw new InvalidKeySpecException("Not a DES key spec");
        }
        try {
            return new DESKeySpec(secretKey.getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Bad key " + invalidKeyException.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (!secretKey.getAlgorithm().equals("DES")) {
            throw new InvalidKeyException("Not a DES key");
        }
        if (!secretKey.getFormat().equals("RAW")) {
            throw new InvalidKeyException("Key in unrecognized format");
        }
        return new DESSecretKey(secretKey.getEncoded());
    }
}

