/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.OctetString;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public final class DESedeParameters
extends AlgorithmParametersSpi {
    private CBCParameter params;
    private IvParameterSpec paramsSpec;

    protected byte[] engineGetEncoded() throws IOException {
        return this.params.encode();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.getName().equals("javax.crypto.spec.IvParameterSpec")) {
            throw new InvalidParameterSpecException(String.valueOf(clazz.getName()) + " not supported");
        }
        return this.paramsSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidParameterSpecException("Not an IV param spec");
        }
        this.paramsSpec = (IvParameterSpec)algorithmParameterSpec;
        this.params = new CBCParameter(this.paramsSpec);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.params = new CBCParameter(byArray);
            this.paramsSpec = this.params.ivSpec;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "DESede Parameters";
    }

    protected class CBCParameter
    extends OctetString {
        private IvParameterSpec ivSpec;

        protected CBCParameter(IvParameterSpec ivParameterSpec) {
            this.ivSpec = ivParameterSpec;
            this.contents = ivParameterSpec.getIV();
        }

        protected CBCParameter(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.ivSpec = new IvParameterSpec(this.contents);
        }
    }
}

