/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.DESedeSecretKey;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class DESedeSecretKeyFactory
extends SecretKeyFactorySpi {
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DESedeKeySpec) {
            return new DESedeSecretKey(((DESedeKeySpec)keySpec).getKey());
        }
        if (keySpec instanceof SecretKeySpec) {
            if (!((SecretKeySpec)keySpec).getAlgorithm().equals("DESede")) {
                throw new InvalidKeySpecException("Not a DESede key spec");
            }
            return new DESedeSecretKey(((SecretKeySpec)keySpec).getEncoded());
        }
        throw new InvalidKeySpecException("Not a DESede key spec");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        if (!secretKey.getAlgorithm().equals("DESede")) {
            throw new InvalidKeySpecException("Not a DESede key");
        }
        if (!secretKey.getFormat().equals("RAW")) {
            throw new InvalidKeySpecException("Key in unrecognized format");
        }
        if (!clazz.getName().equals("javax.crypto.spec.DESedeKeySpec")) {
            throw new InvalidKeySpecException("Not a DESede key spec");
        }
        try {
            return new DESedeKeySpec(secretKey.getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Bad key " + invalidKeyException.getMessage());
        }
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (!secretKey.getAlgorithm().equals("DESede")) {
            throw new InvalidKeyException("Not a DESede key");
        }
        if (!secretKey.getFormat().equals("RAW")) {
            throw new InvalidKeyException("Key in unrecognized format");
        }
        return new DESedeSecretKey(secretKey.getEncoded());
    }
}

